% Function to plot a figure of the flow field.

function flow_fig(title)

global v w NX NY NZ
global v_y_grid v_z_grid xvort_y_grid xvort_z_grid
global x_spacing y_spacing z_spacing
global x_domain y_domain z_domain slice
global zoom_x zoom_y

y_ext = [1:1:NY] ;
z_ext = [1:1:NZ] ;
temp_y_grid = v_y_grid(y_ext)/1000 ;
temp_z_grid = v_z_grid(z_ext) ;
temp2_y_grid = xvort_y_grid(y_ext)/1000 ;
temp2_z_grid = xvort_z_grid(z_ext) ;

psi_levels = [-1 -0.5 0 0.5 1] ;

% Scale for grid in plot.
del_y = 0.5*abs(mean(diff(temp_y_grid)));
del_z = 0.5*abs(mean(diff(temp_z_grid)));

% Take mean and slice of data and extract the required data points (a subset of
% the whole set).
new_v_slice = getyz(v,slice) ;
new_v_slice = new_v_slice(z_ext,y_ext);

% Use v mask for the w mean because w=0 both when there is a land cell and a nearby
% boundary. 
new_w_slice = getyz(w,slice) ;
new_w_slice = new_w_slice(z_ext,y_ext) ;

[x,y] = meshgrid(temp_y_grid,temp_z_grid)  ;
[x2,y2] = meshgrid(temp2_y_grid,temp2_z_grid)  ;

hold on

% Calculate the distance travelled in a certain time.
v_max = max(max(new_v_slice))  ;
w_max = max(max(new_w_slice))  ;
step = 2400 ;
new_v_slice = new_v_slice.*step/1000 ;
new_w_slice = new_w_slice.*step ; 

tom_quiver(x,y,new_v_slice,new_w_slice) ;
set(gca,'XLim',[0 y_domain]) ;
set(gca,'YLim',[-z_domain 0 ]) ;
tit = sprintf('Max [v,w] = [%6.4f,%6.4f] (cm/s)',abs(v_max*100),abs(w_max*100)) ;
text(zoom_x(1),zoom_y(1)-150,tit,'FontSize',9) ;
tit = sprintf('Vector displacements after %4.1f mins',step/60) ;
text(zoom_x(1),zoom_y(1)-200,tit,'FontSize',9) ;
xlabel('Across channel distance (km).') ;
ylabel('Depth (m).') ;
set(gca,'YLim',zoom_y) ;
set(gca,'XLim',zoom_x) ;
t = text(zoom_x(1),zoom_y(2)+150,title) ;
set(t, 'FontSize',16 );

% Do overturning streamfunction.
%figure
stream_fn = psi ;
stream_fn = stream_fn(z_ext,y_ext) ;
c = contour(x2,y2,stream_fn./1e6, 8,'--') ;
%clabel(c,'manual') ;

return
