% Displays a plot of theta and angular momentum.

function theta_fig(title)

global u_y_grid p_y_grid
global u_z_grid p_z_grid
global theta u ang_mom flux time
global x_domain f x_spacing N2 slice y_domain
global zoom_x zoom_y

theta_levels = [ 11:0.01:12]-12 ;
theta_labels = theta_levels ;
%theta_labels = 'manual' ;
ang_mom_levels = [0:-y_domain/30:-y_domain].*f ;
ang_mom_labels = [] ;
%ang_mom_labels = ang_mom_levels ;
%ang_mom_labels = 'manual' ;

figure
set(gca,'YLim',zoom_y) ; 
set(gca,'XLim',zoom_x) ; 
plotslice(theta-12,'yz',slice,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
hold on
plotslice(ang_mom,'yz',slice,u_y_grid,u_z_grid,ang_mom_levels,ang_mom_labels,':') ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(h,'LineWidth',2) ;
hold off

return
