% Function to plot a figure of the tracer field.

function tracer_fig(title)

global trac x_spacing
global p_y_grid p_z_grid
global flux time N2 slice
global zoom_x zoom_y


trac_levels  = [ 0.998,0.996,0.994,0.992,0.99,0.988,0.986,0.984,0.982,0.98] ;
trac_labels  = []  ;

figure
hold on
plotslice(trac,'yz',slice,p_y_grid,p_z_grid,trac_levels,trac_labels,'-') ;
hold on
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;
t=text(0,350,title) ;
set(t,'FontSize',18) ;
set(get(gca,'Title'), 'FontSize',14 );
shading flat
set(gca,'XLim',zoom_x) ;
set(gca,'YLim',zoom_y) ;

return
