% Script to calculate the net vertical heat required to balance the heat transport by
% baroclinic eddies in the mixed layer. User enters format of meridional variation for :
% density, mixed layer depth. Also requires eddy size. 
% Uses parameterisation due to Martin, and simple balance of heat transports in the mixed layer.

% Author : Tom, May '94.

% Setup model parameters, and constants. (SI units throughout).

alpha  = 1e-4 ;
g      = 10 ;
c      = 4e3 ;
f      = 1e-4 ;

Y_lo   = 0 ;
Y_hi   =  5000e3 ;
No_pts = 50 ;


% Setup model variables. Require input of H(y) and rho(y). H is linear in y, rho quadratic.

rhobar     = 1025 ;
maxrho     = 1028 ;
midrho     = 1027.;         

linear_rho = (4*midrho - 3*rhobar - maxrho) / Y_hi      ;
quad_rho   = (maxrho   - rhobar - linear_rho*Y_hi) / Y_hi^2 ;

Hbar       = 200 ;
dHdy       = 0/1e6 ;

deltaY     = 5000 ;

% Calculate Hnet1 as a function of y.

y_grid = [Y_lo : (Y_hi - Y_lo)/No_pts : Y_hi]  ;

H      = Hbar + dHdy.*y_grid  ;
rho    = rhobar + linear_rho.*y_grid + quad_rho.*y_grid.*y_grid  ;
drhody = linear_rho + 2.*quad_rho.*y_grid  ;

Hnet1  = H.*drhody.*( 2.*dHdy.*H.*drhody + ...
                        2*2*quad_rho.*H - ...
                        2*drhody.*drhody.*H./rhobar)  
Hnet1  = Hnet1 *g*c*deltaY/(rhobar*f*alpha)  

subplot(3,1,1) ;
axis([Y_lo Y_hi -max(H) 0.0]) ;
plot(y_grid./1000,-H) ;
xlabel('Distance (km)') ;
ylabel('Mixed layer depth (m)') ;

subplot(3,1,2) ;
plot(y_grid./1000,rho-1000) ;
xlabel('Distance (km)') ;
ylabel('Mixed layer sigma (kgm^-3)') ;

subplot(3,1,3) ;
plot(y_grid./1000,Hnet1) ;
xlabel('Distance (km)') ;
ylabel('Hnet (Wm^-2)') ;
