% Script to do solutions for baroclinic instability in the oceanic mixed layer where
% the Richardson Number is not prescribed as in Hnet3.m (set to 1 here), but rather
% is allowed to vary. The expressions for (v'T')bar, (w'T')bar from Stone 72 are used
% along with the conditions that; Heat/(rhobar.c) = H d/dy( (v'T')bar) and
% H/2 d/dy( (v'T')bar ) + ( w'T')bar|z=H/2 = 0.
% These conditions arise from evaluating div((V'T')bar) = 0 over the mixed layer,
% for the 1st eqn over the whole layer (hence surface flux, Heat) and then over half
% the mixed layer.
% Solution proceeds by eliminating all the extraneous terms from Stone's expression
% for (w'T')bar (Eqn. 2.22, 2.23).

% This script calls RiNo.m, a function which does all the calculations, and essentially
% displays the results.

% Author : Tom, May '94.

% Setup parameters.

clear
global g c rhobar alpha f

% Setup model parameters, and constants. (SI units throughout).

g      = 10 ;
c      = 4e3 ;
rhobar = 1024 ;
alpha  = 2e-4 ;
f      = 1e-4 ;

% Get values of the Heat flux at the surface, the depth of the layer and dH/dy.

Heat = [0.00001:0.00001:.01] ;
H    = 500 ;
dHdy = 1e-4 ;
 
%[Heat,H] = meshgrid(Heat,H) ;
results  = RiNo(Heat,H,dHdy) ;

% Unpack the results vector.

len  = size(results,2)/3 ;
Ri   = results(:,[1:len])  ;
Nmix = results(:,[len+1:2*len])  ;
U0   = results(:,[2*len+1:3*len])  ;


subplot(1,3,1)
plot(Heat,Ri)
xlabel('Surface heat Wm^-2') ;
ylabel('Richardson Number') ;

subplot(1,3,2)
plot(Heat,Nmix)
xlabel('Surface heat Wm^-2') ;
ylabel('Nmix/f') ;

subplot(1,3,3)
plot(Heat,U0)
xlabel('Surface heat Wm^-2') ;
ylabel('Zonal velocity ms^-1') ;

text1 = ['Mixed layer depth = ',num2str(H),', dH/dy = ',num2str(dHdy),'.'] ;
gtext(text1) ;



