% Script which produces a contour plot of Hsurf, the divergence of heat due to baroclinic
% eddies.
% This calculates Hsurf from supplied values of H, mixed layer depth, and dHdy, the
% mixed layer slope by calling the diagnose_Hsurf.m function.
% Complement to Hnet3.m which does forward calculation; finds H by integrating a specified
% Hsurf. SI units throughout.

% Author Tom June 94.

% Set up global variables which are used by diagnose_Hsurf.m
global alpha g gamma c rhobar f Nth beta d2Hdy2 dNthdy

% Set up values of parametrs to be used for this contour plot. Allow for beta term, and also
% include gamma; the empirical constant saying how effective the eddy parameterisation is.
alpha   = 2e-4 ;
g       = 10 ;
gamma   = 1 ;
c       = 4e3 ;
rhobar  = 1024 ;
f       = 1e-4 ;
Nth     = 50 * f ;
beta    = 0e-11 ;
d2Hdy2  = 00/(10000*10000) ;
dNthdy  = (30*f)/10000 ;

% Set up internal variables; arrays of H and dHdy to be used in call to diagnose_Hsurf
% function.
H       = [10:10:1000 ] ;
dHdy    = [5e-5 : 5.0e-5 : 2e-3] ;

[X,Y]   = meshgrid(H,dHdy) ;


% Call diagnose_Hsurf function to generate Hsurf matrix.

Hsurf   = diagnose_Hsurf(X,Y) ;

% Cast dHdy into horizontal temp gradient: K/100km.
Y = Y.*(Nth^2/(alpha*g))*1e5 ;



% Contour plot Hsurf, and mark in max and min points.
contour_levels = [1e-4,1e-3,1e-2,1e-1,0.5,1,2,4,10,20,40,100,200,400,1000,2000,4000] ;
c = contour(X,Y,Hsurf,contour_levels) ;
%clabel(c,'manual'); 
clabel(c) ;

xlabel('Mixed Layer Depth (m)') ;
ylabel('Horizontal temp gradient (K/100km) ') ;
title_text = ['Contour Plot of Eddy Heat Divergence (W/m^2). Thermocline N/f = ', ...
               num2str(Nth/f)] ;
title(title_text) ;

