% function to calculate the surface heat flux as a function of y using a simple
% formula. This is used by the HsurfInteg function, which is itself called by Hnet3.m
% The Hnet3.m script is painfully slow if it has to do both integrations it 
% requires for every position along the y track. Therefore choose a type of function
% for Hsurf(y) which can be integrated directly, at least once. The coefficients
% for this function appear below, and MUST BE THE SAME in the HsurfInteg.m
% function, where the directly integrated form appears.A
% 1/8/94. Add in tanh form for heat loss.

% NB Hsurf +ve means Flux INTO sea.

% Assume form of type Hsurf(y) = a + by +cy^2 + dsin(2 pi y/ ymax) + etanh((y-g)/f)
% e == ymax / 2.

% Author : Tom, May '94

function Hsurf = Hsurf(y)

global A B C D E F YMAX 
YMAX       = 200*1000 ;
A          =  -00 ;
B          =  -00/YMAX ;
C          =  -00/(YMAX * YMAX) ;
D          =  -00 ;
E          =  -100 ;
F          =   25*1000. ;
A          = E ;

Hsurf = A + B.*y + C.*y.^2  + D*sin(2*pi.*y./YMAX) + E*tanh((y-YMAX/2)/F) ;
