% Function to Calculate the value of the integral of :
% ( -(integ(Hsurf dy) - BCterm )) ^ (1/3)
% This is itself integrated by the Hnet3.m function.
% Include a term due to the boundary condition at y=YMAX. This guarantees that the flux
% throught the northern wall, Hlat(y=YMAX) = 0, it is called BCterm, and equals the
% integral of Hsurf from 0 to YMAX, i.e. it is the last term in the out vector. BCterm
% is set in the main body of Hnet3.m.

% To speed up the calculation choose Hsurf(y) which can be directly integrated once.
% The form for Hsurf(y) is  Hsurf(y) = a + by +cy^2 + dsin(2 pi y/ ymax).
% The values of a,b,c,d below MUST BE THE SAME as in the Hsurf.m function.
% This function can then calculate the 1st integral directly.

% 1/8/94. Add minus sign to expression for HsurfInteg. Hsurf is +ve into the sea. 
% Therefore, the divergence of the lateral heat flux must equal - Hsurf.

% Author Tom , May '94.

function HsurfInteg = HsurfInteg(y)

len   = length(y) ;
out   = zeros(1,len) ;

global A B C D E F YMAX BCterm y_zero

% Comment this part out if numerical integration for the 1st integral is not required.
%for i = 1:len
  %out(i) =  (-(quad8('Hsurf',0,y(i)) - BCterm)) .^ (1/3) ;
%end

% This is where the direct integration comes in :
% ASSUMES that integration begins from y_zero.

out = A.*y + 0.5*B*y.*y + (1/3)*C*y.*y.*y - (D*YMAX/(2*pi)).*cos(2*pi.*y./YMAX) ...
      + E*F*log(cosh((y-YMAX/2)/F));

out = out - (A.*y_zero + 0.5*B*y_zero.*y_zero + (1/3)*C*y_zero.*y_zero.*y_zero -    ...
            (D*YMAX/(2*pi)).*cos(2*pi.*y_zero./YMAX) ...
           + E*F*log(cosh((y_zero-YMAX/2)/F)) );

out = (-(out-BCterm)).^(1/3)  ;

if (imag(out) > eps)
   error_text = sprintf('ERROR; HsurfInteg has imaginary answer for y = [%f]. \n',y) ;
   error(error_text) ;
end

HsurfInteg = out ;
