% Short script to work out the value of the mixed layer (PV = 0 layer) strat-
% ification based on a smooth connection with the thermocline beneath (PV > 0). See 
% notes in MIT lab book (3/8/94).
% beta is the angle of the thermocline slope (don't know what the upper limit is on
% this; maybe a degree ?).
% gamma is the angle of the mixed layer deepening (maximum = atan(f/Nth))

% Author Tom, Aug, '94.

% Setup variables.

f     = 1e-4 ;
Nth   = 30*f ;
beta  = .0*pi/180.0 ;
No_pts = 50  ;
gamma = 0 : atan(f/Nth)/(No_pts-1) : atan(f/Nth) ;

% Solve quadratic equation for Nmix.
results = zeros(1,No_pts) ;

for i = 1:No_pts
   poly = [tan(gamma(i))/f 1 -(Nth^2/f)*(tan(gamma(i)) + tan(beta))] ;
   Nmix = roots(poly);
   results(i) = max(Nmix./Nth);
end

% Plot results.
plot(gamma/atan(f/Nth),results)
xlabel('Fraction of maximum mixed layer slope') ;
ylabel('Nmix/Nth') ;

% Old expression has Nmix = Nth^2 * dHdy/f. Plot this up too.
hold on
old_Nmix = Nth^2.*tan(gamma)./f ;
plot(gamma/atan(f/Nth),old_Nmix/Nth) ;

title('Plot comparing old value of mixed layer stratification, with new one') ;

