% Function to do the calculation of Richardson Number, and related parameters from input
% values of Heat, H, and dHdy.
% Function returns the , Nmix and U0, the velocity shear over H.
% See Hnet4.m script for more details of the solution nethod.

% Author : Tom, June '94.

function results = RiNo(Heat, H, dHdy)

% Setup parameters.

global g c rhobar alpha f

% Setup model parameters, and constants. (SI units throughout).

%g      = 10 ;
%c      = 4e3 ;
%rhobar = 1024 ;
%alpha  = 2e-4 ;
%f      = 1e-4 ;

% Get values of the Heat flux at the surface, the depth of the layer and dH/dy.

%Heat = 1000 ;
%H    = 100 ;
%dHdy = 1e-6 ;

% Find zeta and eta; zeta = < (dT'/dz)bar >, eta = < (dT'/dz)bar >.
% Then get Richardson No. Ri = (f^2 * zeta) / ( alpha * g * eta^2) 

eta  = ((12.9.*Heat.^2.*f^4)./(alpha^3*g^3*rhobar^2*c^2.*H.^4.*dHdy.^2)).^(1/5)   ;
zeta = 0.697*((Heat.^2*f^4)./(alpha^3*g^3*rhobar^2*c^2.*H.^4)).^(1/5).*(dHdy.^(-6/5)) - ...
       2.78*((Heat.^4)./(f^2*alpha*g*rhobar^4*c^4.*H.^8.*dHdy.^2)).^(1/5)  ;

% Check Algebra ; these should be zero.

Diagnostic1 = 0.09 * (( H.^2*alpha*g.*eta.^2 ) ./ f ) ./  ...
              (( 1 + (( f^2.*zeta ) ./ ( alpha*g.*eta.^2 ))).^0.5 ) + ...
              Heat./(2*rhobar*c) ;


Diagnostic2 = 0.43 * (( alpha^2*g^2.*H.*dHdy.*eta.^3 ) ./ f^3 ) .* ...
              (( 1 + (( f^2.*zeta) ./ ( alpha*g.*eta.^2 ))).^0.5 ) + ...
              Heat./(H*rhobar*c) ;

%max(Diagnostic1)
%max(Diagnostic2)

Ri   = (f^2.*zeta) ./ (alpha*g.*eta.^2)  ;

Nmix = sqrt( g * alpha .* zeta)/f ;

U0   = eta * alpha * g .* H / f ;

results = [ Ri Nmix U0 ]  ;


