% Script which calculates the effective surface flux due to divergence of heat by
% baroclinic eddies in the mixed layer. See hand-written sheets for formula. Can 
% include a constant beta, and d2Hdy2 term too. This function called by Hnet5.m.
% SI units throughout.

% Author Tom June 94.

% Function definition; X is the H variable; Y the dHdy
function Hsurf = diagnose_Hsurf(X,Y)

% Set up global parameters to be passed from calling script, Hnet5.m
global alpha g gamma c rhobar f Nth beta d2Hdy2 dNthdy

% Debug lines ;

%alpha, g, gamma, c, rhobar, f, Nth, beta, d2Hdy2
%X
%Y

% Calculate the Hsurf required (matrix form).
Hsurf = 2.*X.*Y.*Y*dNthdy + Nth.*X.*d2Hdy2 + Nth.*(Y.*Y) - Nth*beta.*X.*Y./f  ;
Hsurf = Hsurf.*(3*Nth^5*gamma*c*rhobar.*X.*X.*Y.*Y./(f^3*alpha*g))  ;
