% Script to plot dispersion curves from Stone model.
% Note that in the Eady model there is also no long wave cutoff. Beta gives this.
% 22/9/94. Add curve from original Eady model.

% Author Tom Sept. '94.

close
close
clear
Ri = 1 ;
delta = 1 ;
k_lo  = 2e-4 ;
k_hi  = 30 ;
g     = 9.81 ;
rhobar= 1026 ;
H     = 500 ;
Omega  = 7.292e-5 ;
Radian     = 57.29578 ;
f      = 2*Omega*sin(45/Radian) ;

drho_dy = f^2*rhobar/(g*delta) ;
No_pts = 50000 ;
secs_in_a_day = 3600*24 ;
k =   exp([log(k_lo):(log(k_hi)-log(k_lo))/No_pts:log(k_hi)]) ;

% Get Stone's non-dimensional growth rate.
sigma = (1/(2 * sqrt(3))) .* (k - (2/15) .* k.^3 .* (1 + Ri + (5/42)*delta^2.*k.^2)) ;

% Parameters needed for Eady model. Note these are taken from Gill p551ff and are
% DIMENSIONAL until the last stage of calculating sigma. NB in Gill's derivation the
% layer depth, H is actually half the H we have here; define H2 to account for this.
H2      = H/2 ;
Nmix    = (sqrt(Ri) * g * drho_dy) / (rhobar * f) ;
Hr      = H * f./(delta * Nmix .* k) ;
c       = ((g*drho_dy)/(f*rhobar)) .* sqrt((H2.*tanh(H2./Hr) - Hr) .* (H2.*coth(H2./Hr) - Hr)) ;

% Finally get non-dimensional growth rate by scaling with u0.  
sigmaEady = k .* imag(c) .*(rhobar * f) ./ (drho_dy * g * H) ;

figure
un = get(gcf, 'PaperUnits') ;
set(gcf, 'PaperUnits','centimeters') ;
set(gcf, 'PaperPosition', [2, 10,  8.3,  8.3]) ;
set(gcf, 'PaperUnits',un) ;

h = axes('position',[0.15 0.15 0.70 0.70]) ;
plot(k,sigma) ;
axis([0,3,0,0.35])
xlabel('Wavenumber (non-dimensional)', 'FontSize',11) ;
ylabel('Growth Rate (non-dimensional)', 'FontSize',11) ;
text_t = ['Baroclinic instability dispersion relation for Ri = ',num2str(Ri),', delta = ',num2str(delta)] ;
%title(text_t) ;
hold on
plot(k,sigmaEady,'--') ;
tt = text(2.1, 0.3, 'Eady', 'FontSize', 10) ;
tt = text(1.4, 0.2, 'Stone', 'FontSize', 10) ;
set(gca,'FontSize',10) ;
hold off

lambda = 2*pi*g*H*drho_dy./(rhobar*f^2.*k) ;
timesc = 1./(f.*sigma) ;
pts = find(timesc<0) ;
for i = 1:length(pts)
  timesc(pts(i)) = NaN ;
end

timescEady = 1./(f.*sigmaEady) ;
pts = find(timescEady<0) ;
for i = 1:length(pts)
  timescEady(pts(i)) = NaN ;
end

% Add in 2nd axis for dimensional units.
hold on 
lambda = [1500, 2000, 3000, 4000, 5000, 10000,50000] ;
kay = 2*pi*g*H*drho_dy./(rhobar*f^2.*lambda) ;

for i = 1:size(lambda,2)
   tmp = num2str(lambda(i)/1000,2) ;
   text(kay(i),0.36,tmp, 'FontSize',10) ;
end
text(0.8,0.39,'Wavelength (km)', 'FontSize',11) ;

% y-axis.
timesc2 = [0.4, 0.5, 0.7, 1, 2, 3] ;
sigma2  = 1./(f.*timesc2.*secs_in_a_day) ;
for i = 1:size(timesc2,2)
   tmp = num2str(timesc2(i),2) ;
   text(3.1,sigma2(i),tmp, 'FontSize',10) ;
end
tt = text(3.45, 0.08,'Time-scale (days)', 'FontSize',11) ;
set(tt,'Rotation',90)

grid on

wysiwyg
