% Script to read 2D data mixed layer density fields and calculate the density gradients
% then plot a histogram of this. Uses setup codes from the CME.m script, and is the
% corollary of the tsg.m, which plots histograms for tsg data from cruises.

% Author Tom, Sept '94.

close
clear

% Setup constants.
cut_off = 20 ;
True = 1 ;
False = 0 ;
Radian = 57.29578 ;
alpha      = 2e-4 ;
g          = 9.81 ;
gamma      = 0.3 ;
c          = 4e3 ;
Omega      = 7.292e-5 ;
True       = 1 ;
False      = 0 ;
Earth_rad  = 6370e3 ;

markers = '+*.o' ;

global CONST_f DEBUG
global No_x_pts No_y_pts No_vars data_format data_path data_file_name
global dxdeg dydeg longstart latstart y_zoom x_zoom tropics
global ml_depth_cont_levels ml_rho_cont_levels flux_cont_levels heat_cont_levels ...
       K_cont_levels

subplot(2,1,1) ;
hold on

% Loop to read, process and display data sets.

type = -1 ;
count = 1 ;
while(type ~= 9)

  while ((type < 1 | type >5) & type ~= 9 )
    fprintf(1,' Please enter the type of data you want to process') ;
    type = input(' (1 = 1 deg CME, 2 = 1/3 deg CME, 3 = Levitus Atlantic, 4 = Levitus global, 5 = Hnet3 output, 9 = End)  :  ')  ;
  end

    
  if (type == 1)
    setupCME1deg
  elseif (type == 2)
    setupCME1_3deg
  elseif (type == 3)
    setupLevitusAtl
  elseif (type == 4)
    setupLevitusglob
  elseif (type == 5)
    setupHnet3output
    flux_limit_lo = -200 ;
    flux_limit_hi = -0  ;
    Hnet3_f  = 1e-4 ;
  elseif (type == 9)
    break ;
  end

  data_file_name = input(' Please enter the data file name :  ','s') ;
% Setup matrices to give the latitude and longitude of each point in the data matrices.
% These are constructed from the spacing, size, and start information using meshgrid fn.
  x_space = [0:No_x_pts-1] ;
  y_space = [0:No_y_pts-1] ;
  [long,lat] = meshgrid((x_space.*dxdeg + longstart),(y_space.*dydeg + latstart)) ;

% Set longitudes into 0->360.
  long = rem(long,360) ;

% Setup constant spacing variables in radians. Data format is assumed to be arranged on
% evenly spaced spherical coordinates.
  dlong_space = dxdeg / Radian ;
  dlat_space  = dydeg / Radian ;

% Read in data.
  ml_depth = zeros(No_x_pts,No_y_pts*3)  ;
  ml_rho   = zeros(No_x_pts,No_y_pts*3)  ;

  fprintf(1,'Starting read ...') ;
  data = read([data_path,data_file_name], data_format,No_x_pts,No_y_pts,No_vars) ;

  fprintf(1,'Calculating density gradients ...') ;
  ml_depth = data([1:No_y_pts],:) ;
  ml_rho   = data([No_y_pts + 1:2*No_y_pts],:) ;
  
  ml_x     = ml_depth(:,[1:No_x_pts]) ;
  ml_y     = ml_depth(:,[No_x_pts+1:2*No_x_pts]) ;
  ml_depth = ml_depth(:,[2*No_x_pts+1:3*No_x_pts]) ;
  ml_rho   = ml_rho(:,[2*No_x_pts+1:3*No_x_pts]) ;

% Convert density to sigma0 (units kg/m^3)
  ml_rho   = ml_rho - 1000. ;

% Remove land values from matrices. Can't find a neat way to do this with matrix ops.
  [toti,totj] = find(ml_depth == -100) ;
  for i = 1:length(toti)
        ml_depth(toti(i),totj(i)) = NaN ;
        ml_rho(toti(i),totj(i)) = NaN ;
  end
  land = isnan(ml_depth) ;

% Calculate grad(ml_rho) at each grid point.
% Wherever gradients are calculated here the are done so with respect to the lat and long
% in radians, then multiplied by the local value of d(lat)/dy and d(long)/dx. These are
% equal to 1/Earth_rad, and 1/(Earth_rad * cos(lat/Radian)) ;
[drhodx,drhody] = gradient(ml_rho,dlong_space,dlat_space) ;
  drhodx = drhodx ./ (Earth_rad .* cos(lat/Radian)) ;
  drhody = drhody ./ Earth_rad ;
  mod_grad_rho  = sqrt(drhodx.^2 + drhody.^2) ;
  mod_grad_rho  = reshape(mod_grad_rho,size(mod_grad_rho,1)*size(mod_grad_rho,2),1) ;
  mod_grad_rho(isnan(mod_grad_rho)) = [] ;

  
% Do histogram of density gradients.
  fprintf(1,' Calculating normalised histogram of density gradients ... ') ;
  [n,x]    = hist(mod_grad_rho,50) ;
% Remove bins with less than cut_off hits in them.
  [toti,totj] = find(n < cut_off) ;
  n(totj) = [] ;
  x(totj) = [] ; 

  n = n./size(mod_grad_rho,1) ;
  fprintf(1,' done.\n') ;
  semilogy(x,n,markers(count)) ;
  xlabel('Lateral density gradient, kg/m^4') ;
  ylabel('Normalised frequency') ;
  text = sprintf('Histogram of density gradients.') ;
  title(text) ;

  type = -1 ;
  count = count + 1 ;
end

set(gca,'YScale','Log')
set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

hold off
