% Function to do contour maps.
% data matrix set up by (for e.g. the CME.m script). It contains 3 blocks; [X,Y,Z].

% Author Tom, July '94.

function handle = map(x,y,data,mask,levels,colours,labelflag,title_text)

% Constants. Better make sure that True and False have the same value everywhere !
True  = 1 ;
False = 0 ;

% Do contour plot and overlay pcolor plot too.

message = sprintf('Hit <Y> to see a contour plot of "%s".   ',title_text) ;
getkey = input(message,'s') ;
if (getkey == 'Y' | getkey == 'y')

   handle = figure ;

   if ~strcmp(colours,'none')
      if(levels == [])
         pic = contour(x,y,data,'k') ;
      else
         pic = contour(x,y,data,levels,'k') ;
      end
      hold on ;
      colormap(colours) ;
      pcolor(data) ;
      shading interp ;
      hold off
   else
      pic = contour(x,y,data,levels) ;
   end
   
   title(title_text) ;

   getkey = input('Hit <Y> to add on down gradient arrows to plot.    ','s') ;
   if (getkey == 'Y' | getkey == 'y')
       [dx,dy] = gradient(data) ;
       hold on
       quiver(x,y,dx,dy) ;
       hold off
   end

   if (labelflag == True)
      clabel(pic,'manual') ;
   else
      clabel(pic,levels) ;
   end
   
   % Plot on land in white.
   if(mask ~= [])
      hold on
      contour(x,y,mask,[1],'w') ;
      hold off
   end

% Rearrange page
   set(gcf,'PaperOrientation','Landscape') ;
   set(gcf,'PaperPosition',[0.5 0.5 10 7]) ;
            
end
