% Function to read in variably formatted matrices. The data supplied must (currently) be in
% ASCII, and 2 dimensional. I.e. Each line is of the form ( x, y, var1, var2...)
% The x variable must increase most rapidly, or there's trouble !

% Bug fixed on 22/9/96 - twnh.

function output = read(file_name,format,no_x,no_y,no_vars)

% no_x and no_y are the x and y dimensions of the matrix (integers). no_vars is the number
% of z-variables held for each (x,y) pair. Returns matrices ordered (x,y).
% no_y can be set to -1 to allow unknown sizes of data matrix to be loaded.

% Open file.
handle = fopen(file_name, 'r');
if( handle == -1)
  fprintf(1, 'Error in read.m; opening file %s', file_name) ;
  fprintf(1, ' \n\n') ;
  stop
end
fprintf(1, 'Opened file %s \n', file_name) ;

% Read file & close.
fprintf(1, 'Reading data ...') ;
[data,count] = fscanf(handle,format', [2+no_vars inf] ) ;
fprintf(1, ' Read %d records \n', count) ;
fclose(handle) ;
fprintf(1, 'Closed file %s \n\n', file_name) ;

% Unpack data into matrices; one for each no_vars.
% Allow no_y to be free, so that unknown data arrays can be loaded.
if(no_y == -1) 
   no_y = count/((2+no_vars)*no_x) ;
end  
data = data'  ;
x    = zeros(no_x,no_y) ;
y    = zeros(no_x,no_y) ;
x    = reshape(data(:,1),no_x,no_y);
y    = reshape(data(:,2),no_x,no_y);
output = [x',y'] ;
for i = 3:no_vars+2

    temp = reshape(data(:,i),no_x,no_y)' ;
    output = [output,temp] ;

end


