% Script to set up all the relevant variables for use by the CME.m script.     
% 1/3 deg CME data format (see $d8/CME directory, and dumptrace.f in particular).

% Author Tom, Aug '94.

global CONST_f DEBUG
global No_x_pts No_y_pts No_vars data_format data_path data_file_name
global dxdeg dydeg longstart latstart x_zoom y_zoom tropics
global ml_depth_cont_levels ml_rho_cont_levels flux_cont_levels heat_cont_levels ...
       K_cont_levels

CONST_f = False ;
DEBUG   = False ;
No_x_pts = 216;
No_y_pts = 151;
No_vars  = 2 ;
data_format = '%d %d %g %g' ;
data_path   = '/data8/twnh/CME/third_deg/' ;
%data_file_name = 'd003.04.out' ;

% Information about the grid spacing and start in degrees.
dxdeg    = 0.4 ;
dydeg    = 0.333333 ;
longstart= 270 ;
latstart = 10.0 ;

% Information about the contour plots; where to zoom into and where the tropics are.
%x_zoom = [10:80] ;
%y_zoom = [40:110] ;
x_zoom = [1:No_x_pts] ;
y_zoom = [1:No_y_pts] ;
ml_depth_cont_levels = [200,400,800,1200,1600,2000,2500] ;
ml_rho_cont_levels   = [23.0:0.50:28] ;
flux_cont_levels = [1000,2000,4000,80000,16000] ;
heat_cont_levels = [-200,-50,50,200] ;
%K_cont_levels = [150,600,1200] ;
K_cont_levels = [100,300,1000,2000] ;
tropics = [] ;

return
