% Script to set up all the relevant variables for use by the CME.m script.     
% 1deg CME data format (see $d8/CME directory, and dumptrace.f in particular).

% Author Tom, Aug '94.

global CONST_f DEBUG
global No_x_pts No_y_pts No_vars data_format data_path data_file_name
global dxdeg dydeg longstart latstart x_zoom y_zoom tropics
global ml_depth_cont_levels ml_rho_cont_levels flux_cont_levels heat_cont_levels ...
       K_cont_levels

CONST_f = False ;
DEBUG   = False ;
No_x_pts = 85 ;
No_y_pts = 66 ;
No_vars  = 2 ;
data_format = '%d %d %g %g' ;
data_path   = '/data8/twnh/CME/one_deg/' ;
%data_file_name = 'd164.36.out' ;

% Information about the grid spacing and start in degrees.
dxdeg    = 1.2 ;
dydeg    = 1.0 ;
longstart= 259.2 ;
latstart = 0.0 ;

% Information about the contour plots; where to zoom into and where the tropics are.
y_zoom = [1:No_y_pts] ;
x_zoom = [1:No_x_pts] ;
%y_zoom = [45:No_y_pts] ;
%x_zoom = [25:No_x_pts] ;
ml_depth_cont_levels = [100,200,400,800,1200,1600,2000,2500] ;
ml_rho_cont_levels   = [24.0:0.50:28] ;
flux_cont_levels = [0:200:2000] ;
heat_cont_levels = [-100,-50,-20,-15,-10,-5,-1,1,5,10,15,20,50,100] ;
K_cont_levels = [100,200,400,800,1600] ;
tropics = [1:5] ;

return
