% Script to set up all the relevant variables for use by the CME.m script.     
% Diagnostic data from Hnet3.m script, where the surface flux is known.

% Author Tom, Aug '94.

global CONST_f DEBUG
global No_x_pts No_y_pts No_vars data_format data_path data_file_name
global dxdeg dydeg longstart latstart x_zoom y_zoom tropics
global ml_depth_cont_levels ml_rho_cont_levels flux_cont_levels heat_cont_levels ...
       K_cont_levels

CONST_f = True ;
DEBUG   = True ;
No_x_pts = 20 ;
No_y_pts = 200 ;
No_vars  = 2 ;
y_dist   = 200000 ;
data_format = '%g %g %g %g' ;
data_path   = '' ;
%data_file_name = 'Hnet3.output' ;

% Information about the grid spacing in degrees and start latitude.
dxdeg    = 1.0 ;
dydeg    = (y_dist*360)/(No_y_pts*2*pi*Earth_rad) ;
longstart= 315 ;
latstart = 40.0 ;
Hnet3_f  = 1e-4 ;

% Information about the contour plots; where to zoom into.
x_zoom = [1:No_x_pts];
y_zoom = [1:No_y_pts];
ml_depth_cont_levels = [100,200,300,400,500,600,700,800] ;
ml_rho_cont_levels   = [24.0:0.25:28] ;
flux_cont_levels = [-1000,-100,-10,-5,-1,1,5,10,100,1000] ;
heat_cont_levels = [-50:2:50] ;
K_cont_levels = [0:100:2000] ;  
tropics = [] ;
flux_limit_lo = -30 ;
flux_limit_hi = -10 ;

fprintf(1,'\n IMPORTANT !  Check that the Hnet3 output file was created with the ') ;
fprintf(1,'\n              following parameters : Maximum y-distance [%g],',y_dist) ;
fprintf(1,'\n                                     Number of y-points [%g].\n\n',No_y_pts) ;

return
