% Script to set up all the relevant variables for use by the CME.m script.     
% Levitus data from $d8/Levitus/monthly_global.
% Detlef wanted temperature in the output files too (order is i,j,depth,density,temp),
% so include 3 variables in the format definition for these data files.

% Author Tom, Aug '94.

global CONST_f DEBUG
global No_x_pts No_y_pts No_vars data_format data_path data_file_name
global dxdeg dydeg longstart latstart x_zoom y_zoom tropics
global ml_depth_cont_levels ml_rho_cont_levels flux_cont_levels heat_cont_levels ...
       K_cont_levels

CONST_f = False ;
DEBUG   = False ;
No_x_pts = 360;
No_y_pts = 180;
No_vars  = 3 ;
data_format = '%d %d %g %g %g' ;
data_path   = '/data8/twnh/Levitus/monthly_global/' ;

% Information about the grid spacing and start in degrees.
dxdeg    = 1.0 ;
dydeg    = 1.0 ;
longstart= 0.5 ;
latstart = -89.5 ;

% Information about the contour plots; where to zoom into and where the tropics are.
x_zoom = [1:No_x_pts] ;
y_zoom = [1:No_y_pts] ;
%x_zoom = [320:360] ;
%y_zoom = [120:150] ;   
ml_depth_cont_levels = [10,25,50,75,100,150,250,500] ;
ml_rho_cont_levels   = [22.0:1:28] ;
flux_cont_levels = [0:200:2000] ;
heat_cont_levels = [-100,-50,-25,25,50,100] ;
K_cont_levels    = [100,500,1000] ;
tropics = [85:95] ;

return
