% Generic script to set up the diagnostic.m script for a particular channel model run.
% Sets global variables relevant to the specific run in question.
% Use SI variables throughout.

% Author Tom, 25/10/94.

function Expt6

global f N2 alpha x_spacing y_spacing z_spacing this_path NX NY NZ
global x_domain y_domain z_domain
global Half_flux time Initial_temps cooling_width cooling_offset

% Model constants.
f     =  1e-4 ;
N2    =  7e-7/4 ;
alpha =  2e-4 ;

delta_x  = 250 ;
NX       = 200 ;
delta_y  = 250 ;
NY       = 120 ;
delta_z  = 110 ;
NZ       = 20  ;
x_domain = NX*delta_x ;
y_domain = NY*delta_y ;

% Surface forcing.
Half_flux = 400 ;
cooling_width = 10000 ;
cooling_offset = 15000 ;

% Initial temperatures.
Initial_temps = [ ...
        11.9981, 11.9943, 11.9904, 11.9865, 11.9825, 11.9784, 11.9742, 11.9698, 11.9653, 11.9605, ...
        11.9553, 11.9498, 11.9435, 11.9363, 11.9274, 11.9160, 11.8997, 11.8748, 11.8388, 11.7974 ] ;
 
% Setup cell spacings.
x_spacing = ones(1,NX) * delta_x ;
y_spacing = ones(1,NY) * delta_y ;

% Setup z-definition. The Nth z layer is added, because one of the model grids has
% to be land (and we asked for N-1 active layers. Ths thickness of this layer is
% rather arbitrary. Curtis chooses the thickness of the layer immediately above.
% Note that the printouts of model parameters report this incorrectly, at least
% on occasions.
% N.B. The model reads in the level spacing in pressure units; 10* db. Need to scale
% the spacing by 1/g to get the correct spacing in meters for the diagnostic
% software.
z_spacing =  [
             419.100, 423.500, 429.000, 435.900, 444.600, 455.500, 469.500, ...
             487.600, 511.200, 542.600, 585.200, 644.800, 731.300, 862.800, ...
             1075.700,1447.500,2139.300,3340.500,4558.400,4558.400 ] ;
z_spacing = z_spacing * 1/9.81 ;
z_spacing = fliplr(z_spacing)  ;
z_domain  = sum(z_spacing) ;

% Setup file path. 
this_path  = ['/data23/twnh/Channel.exp6'] ;

