% Generic script to set up the diagnostic.m script for a particular channel model run.
% Sets global variables relevant to the specific run in question.
% Use SI variables throughout.

% Author Tom, 25/10/94.

function Expt9

global f N2 alpha x_spacing y_spacing z_spacing this_path NX NY NZ
global x_domain y_domain z_domain
global Half_flux time Initial_temps cooling_width cooling_offset

% Model constants.
f     =  5e-5 ;
N2    =  7e-7 ;
alpha =  2e-4 ;

delta_x  = 250 ;
NX       = 200 ;
delta_y  = 250 ;
NY       = 120 ;
delta_z  = 110 ;
NZ       = 20  ;
x_domain = NX*delta_x ;
y_domain = NY*delta_y ;

% Surface forcing.
Half_flux = 200 ;
cooling_width = 10000 ;
cooling_offset = 15000 ;

% Initial temperatures.
Initial_temps = [
        11.993,  11.977,  11.962,  11.947,  11.931,  11.915,  11.899,  11.882,   ...
        11.864,  11.845, 11.825,  11.803,  11.778,  11.750,  11.715,  11.670,  ...
        11.606,  11.509,  11.368,  11.205 ] ;

% Setup cell spacings.
x_spacing = ones(1,NX) * delta_x ;
y_spacing = ones(1,NY) * delta_y ;

% Setup z-definition. The Nth z layer is added, because one of the model grids has
% to be land (and we asked for N-1 active layers. Ths thickness of this layer is
% rather arbitrary. Curtis chooses the thickness of the layer immediately above.
% Note that the printouts of model parameters report this incorrectly, at least
% on occasions.
% N.B. The model reads in the level spacing in pressure units; 10* db. Need to scale
% the spacing by 1/g to get the correct spacing in meters for the diagnostic
% software.
z_spacing =  [
             419.100, 423.500, 429.000, 435.900, 444.600, 455.500, 469.500, ...
             487.600, 511.200, 542.600, 585.200, 644.800, 731.300, 862.800, ...
             1075.700,1447.500,2139.300,3340.500,4558.400,4558.400 ] ;
z_spacing = z_spacing * 1/9.81 ;
z_spacing = fliplr(z_spacing)  ;
z_domain  = sum(z_spacing) ;

% Setup file path. 
this_path  = ['/data23/twnh/Channel.exp9'] ;

