% Script to calculate and display various diagnostics from the non-hydrostatic channel
% model runs. Reads in data files and then displays plots from the following options
% theta & angular momentum , flow, Ertel's Boussinesq PV, tracer, Richardson No., 
% non-hydrostatic parameter and bird's eye views of vertical vorticity and temperature.
% Each figure has a slice, and an average (except the bird's eye views).
% See diagnostic2.m for time series diagnostics of the channel model.
%
% Author Tom, 25/10/94.

clear
clear global
close all
whos

global x_spacing y_spacing z_spacing NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid RiNo_x_grid xvort_x_grid yvort_x_grid zvort_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid RiNo_y_grid xvort_y_grid yvort_y_grid zvort_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid RiNo_z_grid xvort_z_grid yvort_z_grid zvort_z_grid
global x_domain y_domain z_domain
global u v w theta q E ang_mom trac RiNo delta zvort slice
global f g c N2 alpha rho_bar flux time this_path Half_flux cooling_width cooling_offset


% Plot cross section of this slice
slice = 100 ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ; 
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

% Local variables.
getkey = 'y' ;

% Read in list of parameters for this session. 
param_file_name =   ...
   input(' Please enter the name of the m-file with the parameters for this run : ','s') ;
folder = input(' Please enter the number of the subdirectory for this experiment : ','s') ;

time    = str2num(folder) * 60 ;
info    = [param_file_name,' Day ',num2str(str2num(folder) * 60/secs_in_a_day),' (',folder,') '] ;
title1  = [info,' Temperature (oC) and angular momentum.' ];
message = [' Hit <y> to see a plot of ',title1] ;
getkey1 = input( message,'s') ;

title2  = [info,'  Flow field (m/s).'];
message = [' Hit <y> to see a plot of ',title2] ;
getkey2 = input( message,'s') ;

title3  = [info,' Potential vorticity normalised by initial value.'] ;
message = [' Hit <y> to see a plot of ',title3] ;
getkey3 = input( message,'s') ;

title4  = [info,' Tracer, normalised by initial value.'] ;
message = [' Hit <y> to see a plot of ',title4] ;
getkey4 = input( message,'s') ;

title5  = [info,' Kinetic energy per unit volume (J/m^3). '] ;
message = [' Hit <y> to see a plot of ',title5] ;
getkey5 = input( message,'s') ;

title6  = [info,' Richardson number.'] ;
message = [' Hit <y> to see a plot of ',title6] ;
getkey6 = input( message,'s') ;

title7  = [info,' xy slice of vertical vorticity and temperature.'] ;
message = [' Hit <y> to see a plot of ',title7] ;
getkey7 = input( message,'s') ;

title8  = [info,' plot of N2.'] ;
message = [' Hit <y> to see a plot of ',title8] ;
getkey8 = input( message,'s') ;

title9  = [info,' xy slice of PV.'] ;
message = [' Hit <y> to see a plot of ',title9] ;
getkey9 = input( message,'s') ;

title10  = [info,' Scatter plot of PV vs N2.'] ;
message = [' Hit <y> to see a plot of ',title10] ;
getkey10 = input( message,'s') ;

fprintf(1,' \n\n') ;

feval(param_file_name) ;
this_path   = [this_path,'/',folder] ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

% Get surface fluxes.
flux     = Half_flux.*(tanh((2.*(p_y_grid + 125 - cooling_offset))./cooling_width) + 1 ) ;
flux     = [p_y_grid',flux'] ;

% Print figures, of theta & ang_mom, flow, PV tracer and Ri/delta, with upper panel 
% showing a slice and lower panel the along channel mean.

if(getkey1 == 'y' | getkey1 == 'Y')

   read_fields(1,0,1,0,0,0,this_path) ;
% Rough calculation of angular momentum.
   fprintf(1,' Calculating angular momentum ... \n') ;
   ang_mom = zeros(NY,NZ*NX) ;
   temp  = reshape(u,NY,NX*NZ) ;
   temp2 = meshgrid(f.*u_y_grid,[1:NX*NZ])' ;
   ang_mom = temp - temp2 ;
   ang_mom = reshape(ang_mom,NY*NZ,NX) ;
   clear temp ;
   clear temp2 ;

   theta_fig(title1) ;
   %clear global ang_mom ;
end

if(getkey2 == 'y' | getkey2 == 'Y')
   read_fields(0,0,1,0,0,0,this_path) ;
   flow_fig(title2) ;
end

if(getkey3 == 'y' | getkey3 == 'Y')
   read_fields(1,0,1,1,1,0,this_path) ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
   temp = [this_path,'/','q.mat'] ;
   if( fopen(temp) == -1)
      PV ;
      fid = fopen(temp,'w') ;
      fwrite(fid,q,'float32') ;
%  Reload model variables (PV function clears them).
      global theta u v w
      theta = readmodel('theta.sun.b',this_path,'float32') ;
      u = readmodel('u.sun.b',this_path,'float32') ;
      v = readmodel('v.sun.b',this_path,'float32') ;
      w = readmodel('w.sun.b',this_path,'float32') ;
      w = w./(-g*rho_bar) ;
   else
      fprintf(1,' Retrieving PV from disk ... \n') ;
      fid = fopen(temp,'r') ;
      q = fread(fid,[NY*NZ,NX],'float32') ;
   end
   fclose(fid) ;
   q = -q.*g./(f.*N2) ;
   clear temp

   PV_fig(title3) ;
end

if(getkey4 == 'y' | getkey4 == 'Y')
   read_fields(0,1,0,0,0,0,this_path) ;

   trac = readmodel('salt.sun.b',this_path,'float32')./36 ;
   tracer_fig(title4) ;
   clear trac  
end

if(getkey5 == 'y' | getkey5 == 'Y')
   read_fields(1,0,1,1,1,0,this_path) ;
% Get KE.
   temp = [this_path,'/','KE.mat'] ;
   if( fopen(temp) == -1)
      KE ;
      fid = fopen(temp,'w') ;
      fwrite(fid,q,'float32') ;
   else
      fprintf(1,' Retrieving KE from disk ... \n') ;
      fid = fopen(temp,'r') ;
      E   = fread(fid,[NY*NZ,NX],'float32') ;
   end
   fclose(fid) ;
   clear temp

   KE_fig(title5) ;
end

if(getkey6 == 'y' | getkey6 == 'Y')
   fid = fopen([this_path,'/RiNo.mat'],'r') ;
   RiNo = fread(fid,[NY*NZ,NX],'float32') ;
   fclose(fid) ;
   fid = fopen([this_path,'/delta.mat'],'r') ;
   delta = fread(fid,[NY*NZ,NX],'float32') ;
   fclose(fid) ;
   RiNo_delta_fig(title6) ;
   %clear RiNo delta
end


% Do figure of vertical vorticity and temperature field from bird's eye
% view.

if(getkey7 == 'y' | getkey7 == 'Y')
   read_fields(1,0,0,0,0,0,this_path) ;
   fid = fopen([this_path,'/zvort.mat'],'r') ;
   zvort = fread(fid,[NY*NZ,NX],'float32') ;
   fclose(fid) ;
   vort_theta_fig(title7) ;
   clear RiNo delta
end

% Do figure of N2. 
if(getkey8 == 'y' | getkey8 == 'Y')
   read_fields(1,0,0,0,0,0,this_path) ;
   mean_N2_fig(title8) ;
end


% Do figure of PV from bird's eye view.
if(getkey9 == 'y' | getkey9 == 'Y')

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
   temp = [this_path,'/','q.mat'] ;
   if( fopen(temp) == -1)
      read_fields(1,0,1,1,1,0,this_path) ;
      PV ;
      fid = fopen(temp,'w') ;
      fwrite(fid,q,'float32') ;
   else
      fprintf(1,' Retrieving PV from disk ... \n') ;
      fid = fopen(temp,'r') ;
      q = fread(fid,[NY*NZ,NX],'float32') ;
   end
   fclose(fid) ;
   q = -q.*g./(f.*N2) ;
   clear temp

   PV_slice_fig(title9) ;
end

% Do figure of slice of N2 and scatter plot of PV vs N2..
if(getkey10 == 'y' | getkey10 == 'Y')

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
   temp = [this_path,'/','q.mat'] ;
   if( fopen(temp) == -1)
      read_fields(1,0,1,1,0,0,this_path) ;
      PV ;
      fid = fopen(temp,'w') ;
      fwrite(fid,q,'float32') ;
   else
      fprintf(1,' Retrieving PV from disk ... \n') ;
      fid = fopen(temp,'r') ;
      q = fread(fid,[NY*NZ,NX],'float32') ;
   end
   fclose(fid) ;
   q = -q.*g./(f.*N2) ;
   clear temp
   read_fields(1,0,0,0,0,0,this_path) ;

   N2_PV_scatter_fig(title10) ;
end

