% Script to read and display a figure from the ACCP poster.      
% This function displays 3 contour plots of the temperature from the 
% channel model, Expt1viii. These are at days 3, 6 and 9.
% 
% Author : tom 24/4/95.

% Setup variables for plot; model constants and grids etc.

clear global
clear
close all

global p_x_grid p_y_grid p_z_grid zvort_x_grid zvort_y_grid zvort_z_grid
global theta zvort x_spacing y_spacing z_spacing this_path NX NY NZ
global x_domain y_domain z_domain f

% Define whether you want a contour or colour map here (0 = colours). 
% Colour mapping is slow. Also define whether or not 2 figures are printed, 
% or everything on one page. Also define how each subplot is stretched from 
%  the matlab default.
option = 0 ;
adjustment = [1,1,1,1] ;

Expt1
setup_grids(x_spacing, y_spacing, z_spacing) ;
slice_no = 19 ;
days = [3,6,9] ;

figure
colormap(jet)

% Read in temperature field at days 3, 6 and 9 from disk.
for i = 1:size(days,2)
   path = [this_path,'/',num2str(days(i)*60*24,5)] ;
   theta = readmodel('theta.sun.b',path,'float32') ;
   theta_slice = getxy(theta,slice_no) ;
   clear theta

% Flip slice so the cooled region is to the North.
   theta_slice = flipud(theta_slice) ;

   theta_depth    = num2str(p_z_grid(slice_no)) ;

% Get max, min values and remove land from slices.
   mask  = find(theta_slice < 2 ) ;
% Get max values
   temp  = -99.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;
   max_theta         = max(max(theta_slice));

% Get min values
   temp  = 99.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;
   min_theta         = min(min(theta_slice))

% Remove land.
   temp  = NaN.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;

   subplot(3,1,i) ;

   if(option == 1)
      c = contour(p_x_grid./1000,p_y_grid./1000,theta_slice,6) ;
   else
      pcolor(p_x_grid./1000,p_y_grid./1000,theta_slice) ;
      shading flat
      caxis([11.6,12]) ;
      set(gca,'AspectRatio',[x_domain/y_domain,1]) ;
   end
   hold on
   sub_title = ['Day ',num2str(days(i))] ;
   text(5,5,sub_title,'FontSize', 14) ;

end

subplot(3,1,2) ;
text(-5,2,'Across channel distance (km).','Rotation',90) ;
text(55, -5, 'Temperature (C)') ;
temp = gca ; 
p = get(gca,'Position') ;
h = colorbar('vert') ;
set(temp,'Position',p) ;

subplot(3,1,3) ;
xlabel('Along channel distance (km).') ;

un = get(gcf,'PaperUnits') ;
set(gcf,'PaperUnits', 'centimeters') ;
set(gcf,'PaperPosition',[1.0,2.0,19,25.5]) ;
set(gcf,'PaperUnits', un) ;


return
