% Function to plot a figure of the kinetic energy distribution.

function KE_fig(title)

global E slice
global p_y_grid p_z_grid x_spacing

E_levels     = [1,2,4,8,16,32,64] ;
E_labels     = E_levels ;


figure
   subplot(2,1,1)
   plotslice(E,'yz',slice,p_y_grid,p_z_grid,E_levels,E_labels,'-') ;
   text(0,350,title) ;
   set(get(gca,'Title'), 'FontSize',14 );

   subplot(2,1,2)
   hold on
   plotmean(E,'yz',x_spacing,p_y_grid,p_z_grid,E_levels,E_labels,'-') ;
   set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

return

