% Displays a bird's eye view of N2. 

function N2_PV_scatter_fig(title_text)

global p_x_grid p_y_grid p_z_grid 
global N2 x_spacing theta g alpha z_domain x_domain y_domain q
global N2_slice q_slice NX NY NZ
global w_z_grid PV_x_grid PV_z_grid PV_y_grid

slice_no = 11 ;
N2depth    = num2str(w_z_grid(slice_no)) ;
N2_levels  = [-0.5,-0.2,0,0.2,0.5,1,1.5] ;

% Just calculate N2 in the vicinity of the horizontal slice.
fprintf(1,' Calculating N2 ... ') ;
theta_sub  = theta([(slice_no-2)*NY+1:((slice_no)*NY)],:) ;
mask  = find(abs(theta_sub) < eps) ;
temp = NaN.*ones(size(mask)) ;
theta_sub(mask) = temp ;
grid_sub   = [p_z_grid(slice_no-1),p_z_grid(slice_no)] ;
domain_sub = 500 ;
temp_NZ = NZ ;
NZ = 2 ;
N2obs = (g*alpha).*d_dn(theta_sub,'z',grid_sub,domain_sub)./N2 ;

% Regrid N2 to the same points as PV values for scatter plot.
regrid(N2obs,'x',p_x_grid,PV_x_grid,x_domain) ;
regrid(N2obs,'y',p_y_grid,PV_y_grid,y_domain) ;
N2_slice =  getxy(N2obs,2) ;
NZ = temp_NZ ;

% Compare answer with N2 from full derivative (testing only).
% These should be identical.
%N2obs2 = (g*alpha).*d_dn(theta,'z',p_z_grid,z_domain)./N2 ;
%N2obs2 = getxy(N2obs2,slice_no) ;

q_slice   = getxy(q,slice_no) ;

% Get max, min values and remove land from N2.
mask  = find(isnan(N2_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
N2_slice(mask)  = temp ;
max_N2          = max(max(N2_slice))  

% Get min values
temp  = 99.*ones(size(mask)) ;
N2_slice(mask)  = temp ;
min_N2          = min(min(N2_slice)) 

% Remove land.
temp  = NaN.*ones(size(mask)) ;
N2_slice(mask)  = temp ;

% Get max, min values and remove land from PV.
mask  = find(isnan(q_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
max_q          = max(max(q_slice))

% Get min values
temp  = 99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
min_q          = min(min(q_slice))

% Remove land.
temp  = NaN.*ones(size(mask)) ;
q_slice(mask)  = temp ;


% Bin N2 and PV to create plot of volumetric census.
fprintf(1,' Binning ...') ;
temp_N2_slice = N2_slice ;
temp_q_slice  = q_slice ;
del     = 6/90 ;
del2 = del/2 ;
q_bins = [-0.5:del:1.5] ;
N2_bins = [-0.5:del:1.5] ;
hits = zeros(length(N2_bins),length(q_bins)) ;
for i = 1:length(N2_bins)
   for j = 1:length(q_bins)
      temp = find(  ...
      (temp_N2_slice < N2_bins(i)+del2) & (temp_N2_slice > N2_bins(i)-del2)) ;
      temp2 = find( ...
      (temp_q_slice(temp) < q_bins(j)+del2) & (temp_q_slice(temp) > q_bins(j)-del2)  ) ;
      hits(i,j) = length(temp2) ;
      temp_N2_slice(temp2) = [] ;
      temp_q_slice(temp2) = [] ;
   end
end

figure
%plot(reshape(q_slice,1,NX*NY),reshape(N2_slice,1,NX*NY),'.') ;
title([title_text,' at ',N2depth,'m depth.'],'FontSize',14) ;
ylabel('Normalised PV') ;
xlabel('Normalised N2') ;
axis([min(N2_bins) max(N2_bins) min(q_bins) max(q_bins)]) ;
hold on
pcolor(N2_bins,q_bins,log(1+hits')) ;
plot([-10 10],[-10,10],'-') ;
colorbar('vert')
grid

return
