% Function to draw a figure of the PV.

function PV_fig(title)


global q  x_spacing
global PV_y_grid PV_z_grid
global flux time N2 slice

q_levels     = [ 1.25,1.0,0.5,0.25,0.1,0.05,-1.0] ;
q_labels     = [ 1.25,1.0,0.5,0.25,0.1,0.05,-1.0] ;
%q_labels = 'manual' ;


figure
subplot(2,1,1)
hold on
plotslice(q,'yz',slice,PV_y_grid,PV_z_grid,q_levels,q_labels,'-') ;
hold on
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;

t = text(0,350,title) ;
set(t,'FontSize',18) ;
%caxis([-.5,1]) ;
%shading flat
%h1 = colorbar ;

subplot(2,1,2)
hold on
plotmean(q,'yz',x_spacing,PV_y_grid,PV_z_grid,q_levels,q_labels,'-') ;
hold on
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;
hold off
set(get(gca,'Title'), 'FontSize',14 );
%caxis([-.5,1]) ;
%shading flat
%h2 = colorbar ;


set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

return
