% Displays a bird's eye view of Potential vorticity. 

function PV_slice_fig(title_text)

global PV_x_grid PV_y_grid PV_z_grid 
global q
global f

slice_no = 11 ;
PVdepth    = num2str(PV_z_grid(slice_no)) ;
PV_levels  = [-0.5,-0.2,0,0.2,0.5,1,1.5] ;

PV_slice  = getxy(q,slice_no) ;

% Get max, min values and remove land from PV.
mask  = find(isnan(PV_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
PV_slice(mask)  = temp ;
max_PV          = max(max(PV_slice))  

% Get min values
temp  = 99.*ones(size(mask)) ;
PV_slice(mask)  = temp ;
min_PV          = min(min(PV_slice)) 

% Remove land.
temp  = NaN.*ones(size(mask)) ;
PV_slice(mask)  = temp ;

figure
pcolor(PV_x_grid./1000,PV_y_grid./1000,PV_slice) ;
shading flat
caxis([-0.2,1.2]) ;
colorbar('vert') ;
colormap(hsv)
hold on
%c=contour(PV_x_grid./1000,PV_y_grid./1000,PV_slice,PV_levels,'--k') ;
%clabel(c,'manual') ;
title([title_text,'PV field at ',PVdepth,'m depth.'],'FontSize',14) ;
xlabel('Along channel distance (km).') ;
ylabel('Across channel distance (km).') ;

%orient tall
return
