% Script to create a figure for the proposal. This is based on the
% BigSky abstract, and consists of 2 figures.
% Figure 1 is an along channel average PV. 
% Figure 2 is an along channel average tracer. 
% 
% Author : tom 1/8/95. 

% Setup variables for plot; model constants and grids etc.

clear global
clear
close all

global p_x_grid p_y_grid p_z_grid zvort_x_grid zvort_y_grid zvort_z_grid
global theta zvort x_spacing y_spacing z_spacing this_path NX NY NZ
global x_domain y_domain z_domain f N2 time Half_flux g c rho_bar alpha
global PV_y_grid PV_z_grid p_y_grid u_x_grid u_y_grid

% Setup contouring levels.
PV_levels = [0.01,0.3,0.6,0.9] ;
PV_labels = PV_levels ;    
PV_style    = '-' ;
tracer_levels = [0.2,0.4,0.6,0.8] ;

% Size of picture.
new_size   = 2*[8.3,6.5] ;

secs_in_a_day = 60*60*24 ;
g             = 9.81 ;
c             = 4e3 ;
rho_bar       = 1000 ;
new_size   = [8.3,6.5] ;
font_size  = 12 ;
font_name  = 'Helvetica' ;
days = [9] ;

Expt1
setup_grids(x_spacing, y_spacing, z_spacing) ;

% Start figure  now.

% Define how each subplot is stretched form the matlab default.
   adjustment = [1.25,1,0.9,1] ;

% Setup grids.
   abs_grid  = p_y_grid./1000 ;
   ord_grid  = p_z_grid(1:NZ) ;
   abs_len   = [0,y_domain]./1000 ;
   ord_len   = [-z_domain,0] ;
   abs_N     = NY ;
   ord_N     = NZ ;
   new_abs_N = NY ;
   new_ord_N = NZ * 2 ;
   Grid_type = 0 ;
   slice_no  = 19 ;

% Surface forcing. See notes in white lab book about definition of flux used (23/1/95);
% it has several peculiar and unexpected features. Comment out peculiarities for plots; 
% they make them look messy, and are minor modifications. 
   flux     = Half_flux.*(tanh((2.*(p_y_grid +125 - 15000))./10000) + 1 ) ;
%flux(1:9) = zeros(size(1:9)) ;
%flux(NY)  = 0 ;
%flux(1)   = 0 ;
   flux     = [p_y_grid',flipud(flux')] ;

   if( std(diff(abs_grid)) > eps | std(diff(ord_grid)) > eps )
      Grid_type = 1 ;
      x = [abs_grid(1) : (abs_grid(abs_N)-abs_grid(1))/(new_abs_N-1) : abs_grid(abs_N)]  ;
      y = [ord_grid(1) : (ord_grid(ord_N)-ord_grid(1))/(new_ord_N-1) : ord_grid(ord_N)]  ;
      [X,Y] = meshgrid(x,y)   ;
      [old_x,old_y] = meshgrid(abs_grid,ord_grid) ;
   else
      [X,Y] = meshgrid(abs_grid,ord_grid) ;
   end

% Setup grids.
   abs_grid  = PV_y_grid./1000 ;
   ord_grid  = PV_z_grid(1:NZ) ;
   abs_len   = [0,y_domain]./1000 ;
   ord_len   = [-z_domain,0] ;
   abs_N     = NY ;
   ord_N     = NZ ;
   new_abs_N = NY ;
   new_ord_N = NZ * 2 ;

   if( std(diff(abs_grid)) > eps | std(diff(ord_grid)) > eps )
      Grid_type = 1 ;
      x = [abs_grid(1) : (abs_grid(abs_N)-abs_grid(1))/(new_abs_N-1) : abs_grid(abs_N)]  ;
      y = [ord_grid(1) : (ord_grid(ord_N)-ord_grid(1))/(new_ord_N-1) : ord_grid(ord_N)]  ;
      [X,Y] = meshgrid(x,y)   ;
      [old_x,old_y] = meshgrid(abs_grid,ord_grid) ;
   else
      [X,Y] = meshgrid(abs_grid,ord_grid) ;
   end

% Read in PV from disk.
   fprintf(1,' Day [%d] ... \n',days) ;
   path = [this_path,'/',num2str(days*60*24,5),'/q.mat'] ;
   fid  = fopen(path,'r') ;
   if ( fid == -1)
      fprintf(1,' ERROR !  Cannot read file [%s]. \n\n', path) ;
      return ;
   end
   q = fread(fid,[NY*NZ,NX],'float32') ;
   fclose(fid) ;
   q = -q.*g/(f*N2) ;
  
% Get max, min values and remove land from slices.
   mask     = find(isnan(q)) ;
   q2       = q ;
% Get max values
   temp     = -99.*ones(size(mask)) ;
   q2(mask) = temp ;
   max_q    = max(max(q2)) ;

% Get min values
   temp     = 99.*ones(size(mask)) ;
   q2(mask) = temp ;
   min_q    = min(min(q2))  ;

% Set mask for average function below.
   mask     = ~isnan(q) ;

% Get mean.
  PV_mean     = meanyz(q,x_spacing,mask) ;

% Flip fields so the cooled region is to the North.
   PV_mean    = fliplr(PV_mean) ;

% Regrid if needs be (z-grid is uneven).
   if( Grid_type == 1)
      fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
      PV_mean    = interp2(old_x,old_y,PV_mean,X,Y) ;
   end

   clear q q2 mask

% Do tracer now.

% Setup grids.
   abs_grid  = p_y_grid./1000 ;
   ord_grid  = p_z_grid(1:NZ) ;
   abs_len   = [0,y_domain]./1000 ;
   ord_len   = [-z_domain,0] ;
   abs_N     = NY ;
   ord_N     = NZ ;
   new_abs_N = NY ;
   new_ord_N = NZ * 2 ;

   if( std(diff(abs_grid)) > eps | std(diff(ord_grid)) > eps )
      Grid_type = 1 ;
      x = [abs_grid(1) : (abs_grid(abs_N)-abs_grid(1))/(new_abs_N-1) : abs_grid(abs_N)]  ;
      y = [ord_grid(1) : (ord_grid(ord_N)-ord_grid(1))/(new_ord_N-1) : ord_grid(ord_N)]  ;
      [X,Y] = meshgrid(x,y)   ;
      [old_x,old_y] = meshgrid(abs_grid,ord_grid) ;
   else
      [X,Y] = meshgrid(abs_grid,ord_grid) ;
   end

% Read in tracer from disk.     
   fprintf(1,' Day [%d] ... \n',days) ;
   path = [this_path,'/',num2str(days*60*24,5)] ;
   tracer      = readmodel('salt.sun.b',path,'float32') ;

% Get max, min values and remove land from slices.
   mask     = find(tracer<10*eps) ;
   tracer2       = tracer ;
% Get max values
   temp     = -99.*ones(size(mask)) ;
   tracer2(mask) = temp ;
   max_tracer    = max(max(tracer2)) ;

% Get min values
   temp     = 99.*ones(size(mask)) ;
   tracer2(mask) = temp ;
   min_tracer    = min(min(tracer2))  ;

% Set mask for average function below.
   temp  = NaN.*ones(size(mask)) ;
   tracer(mask)  = temp ;
   mask  = ~isnan(tracer) ;

% Normalise tracer values.
   tracer = (tracer - max_tracer + 0.5) .*2 ;

% Get mean.
  tracer_mean     = meanyz(tracer,x_spacing,mask) ;

% Flip fields so the cooled region is to the North.
   tracer_mean    = fliplr(tracer_mean) ;

% Regrid if needs be (z-grid is uneven).
   if( Grid_type == 1)
      fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
      tracer_mean    = interp2(old_x,old_y,tracer_mean,X,Y) ;
   end


% Start plotting.
   figure

% First plot is PV.
   subplot(2,1,1) ;
   hold on
   c = contour(X(1,:)',Y(:,1),PV_mean,PV_levels) ;
    clabel(c,'manual') ;
   set(gca,'AspectRatio',[1.5,NaN]) ;
   text(35,-750,'Normalised PV') ;
   axis([0 y_domain/1000 -1500 0] ) ;

% Second plot is tracer.
   subplot(2,1,2) ; 
   hold on
   c = contour(X(1,:)',Y(:,1),PV_mean,tracer_levels) ;
   clabel(c,'manual') ;
   set(gca,'AspectRatio',[1.5,NaN]) ;
   text(37,-750,'Tracer') ;
   axis([0 y_domain/1000 -1500 0] ) ;

% Annotate subplots.
   subplot(2,1,1) ;
   ylabel('Depth (m)') ;
   xlabel('Across channel distance (km).','FontName',font_name,'FontSize',font_size) ;
   set(gca,'XGrid','on') ;
   set(gca,'YGrid','on') ;

   subplot(2,1,2) ;
   ylabel('Depth (m)') ;
   xlabel('Across channel distance (km).','FontName',font_name,'FontSize',font_size) ;
   set(gca,'XGrid','on') ;
   set(gca,'YGrid','on') ;

   old_units = get(gcf,'Units') ;
   set(gcf,'PaperUnits','centimeters') ;
   old_pos = get(gcf,'PaperPosition') ;
   set(gcf,'PaperPosition',[old_pos(1),old_pos(2),new_size]) ;
   set(gcf,'Units',old_units) ;


return
