% Displays a plot of the Richardson No. and the non-hydrostatic parameter, delta.

function RiNo_delta_fig(title)

global RiNo_y_grid 
global RiNo_z_grid 
global RiNo delta flux time
global x_domain f x_spacing N2 slice

RiNo_levels = -[1,5,10,50,100,500] ; 
RiNo_labels = RiNo_levels ;
RiNo_labels = 'manual' ;
delta_levels = [0.001,0.01,0.1,1,10] ;
delta_labels = delta_levels ;
%delta_labels = 'manual' ;

figure
subplot(2,1,1)
plotslice(RiNo,'yz',slice,RiNo_y_grid,RiNo_z_grid,RiNo_levels,RiNo_labels,'-') ;
hold on
%plotslice(delta,'yz',slice,RiNo_y_grid,RiNo_z_grid,delta_levels,delta_labels,':') ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(h,'LineWidth',2) ;
hold off
t = text(0,350,title) ;
set(t,'FontSize',18) ;
set(gca,'YLim',[-2000 0]) ;

subplot(2,1,2)
plotmean(RiNo,'yz',x_spacing,RiNo_y_grid,RiNo_z_grid,RiNo_levels,RiNo_labels,'-') ;
hold on
%plotslice(delta,'yz',slice,RiNo_y_grid,RiNo_z_grid,delta_levels,delta_labels,':') ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(h,'LineWidth',2) ;
hold off
t = text(0,350,title) ;
set(t,'FontSize',18) ;
set(gca,'YLim',[-2000 0]) ;

%figure
%subplot(2,1,2)
%plotmean(RiNo,'yz',x_spacing,RiNo_y_grid,RiNo_z_grid,RiNo_levels,RiNo_labels,'-') ;
%hold on
%plotmean(delta,'yz',x_spacing,RiNo_y_grid,RiNo_z_grid,delta_levels,delta_labels,':') ;
%h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
%set(h,'LineWidth',2) ;
%hold off
%
set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

return
