% Script to plot two figures for the diagnostic2.m program.
% Plot of T, v, and the T autocorelation along the channel, at the channel centre and
% different times.

function auto_correl_fig(i,p_x_grid,theta_prime,one_D_temp,times,theta_corr, ...
                         param_file_name,v_prime,v_corr)
figure
for j = 1:i
   subplot(i,2,2*j-1)
   plot(p_x_grid./1000,theta_prime(j,:))
   axis([0 50 11.5 12]) ;
   ylabel(['Day ',int2str(times(j))]) ;
   hold on
   plot([0 200], [one_D_temp(j) one_D_temp(j)], ':') ;
   hold off
   subplot(i,2,2*j)
   plot(p_x_grid([1:floor(NX/2)])./1000,theta_corr(j,:))
   axis([0 25 -1 1]) ;
end

subplot(i,2,1)
hold on
text(0,12.5,'Along channel center, surface temp and 1-D model (..).') ;
hold off
subplot(i,2,2)
hold on
text(-10,2,'Along channel center, surface temp autocorrelation.') ;
hold off
subplot(i,2,i*2-1)
hold on
xlabel('Along channel distance (km)') ;
t = text(0,10.7,param_file_name) ;
set(t,'FontSize',14) ;
hold off
subplot(i,2,i*2)
hold on
xlabel('Along channel distance (km)') ;
hold off

orient tall

figure
for j = 1:i
   subplot(i,2,2*j-1)
   plot(p_x_grid./1000,v_prime(j,:))
   axis([0 200*0.25 -0.5 0.5]) ;
   ylabel(['Day ',int2str(times(j))]) ;
   subplot(i,2,2*j)
   plot(p_x_grid([1:floor(NX/2)])./1000,v_corr(j,:))
   %axis([0 200 -1 1]) ;
end
subplot(i,2,1)
hold on
text(0,1,'Along channel center, surface v.') ;
hold off
subplot(i,2,2)
hold on
text(0,2,'Along channel center, surface v autocorrelation.') ;
hold off
subplot(i,2,i*2-1)
hold on
xlabel('Along channel distance (km)') ;
t = text(0,-2,param_file_name) ;
set(t,'FontSize',14) ;
hold off
subplot(i,2,i*2)
hold on
xlabel('Along channel distance (km)') ;
hold off

orient tall
return ;
