% Function to plot a figure of the flow field.

function flow_fig(title)

global u 
global u_y_grid u_z_grid 
global w_y_grid w_z_grid
global x_spacing slice

u_levels     = [-1:0.05:1] ;
u_labels     = u_levels ;

figure
subplot(2,1,2)
plotmean(u,'yz',x_spacing,u_y_grid,u_z_grid,u_levels,u_levels,'-') ;
%hold on
%[x,y] = meshgrid(w_y_grid,w_z_grid) ;
%quiver(x,y,meanyz(v,x_spacing,(abs(v)>eps)),meanyz(w,x_spacing,(abs(w)>eps))) ;
%hold off
set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;
clear ang_mom x y
subplot(2,1,1)
plotslice(u,'yz',slice,u_y_grid,u_z_grid,u_levels,u_levels,'-') ;
hold on
[x,y] = meshgrid(w_y_grid,w_z_grid) ;
%quiver(x,y,getyz(v,100),getyz(w,100)) ;
hold off
t = text(0,350,title) ;
set(t, 'FontSize',18 );


return
