% Script to plot a figure of the heat budget from the CM5 channel model integrations.
% Called from diagnostic2.m.
% Author : Tom Haine, Feb '95.

function heat_budget_fig(i, times, Nhalf, Shalf, sum, param_file_name, ...
                         Shalf_lost, Nhalf_lost, tinst, best_gamma, fit) ;

% Draw a figure of heat budget.
figure
subplot(2,1,1)
plot(times, Nhalf, '+') ;
hold on
plot(times, Nhalf_lost, '*') ;
plot(times, sum,'o') ;
title([param_file_name,' Northern half channel heat content.']) ;
xlabel('Model daynumber') ;
ylabel('Half channel heat content (J)') ;
text(4,0,'+ = Full model and fit; * = 1D prediction; o = drift.') ;
axis([0 times(i) min([Nhalf;Nhalf_lost;sum]) max([Nhalf;Nhalf_lost;sum])]) ;
subplot(2,1,2)
plot(times, Shalf, '+') ;
hold on
plot(times, Shalf_lost, '*') ;
plot(times, sum,'o') ;
plot(times, fit, ':') ;
title([param_file_name,' Southern half channel heat content.']) ;
xlabel('Model daynumber') ;
ylabel('Half channel heat content (J)') ;
text(4,0,'+ = Full model; * = 1D prediction; o = drift.') ;
axis([0 times(i) min([Shalf;Shalf_lost;sum]) max([Shalf;Shalf_lost;sum])]) ;

message = ['Instability time scale = [',num2str(tinst),'] days.'] ;
text(1, min([Shalf;Shalf_lost;sum])*0.7, message) ;

hold off

message = ['Best fit gamma = [',num2str(best_gamma),'].'] ;
text(1, min([Shalf;Shalf_lost;sum])*0.9, message ) ;

orient tall
hold off


return
