% Function to draw a figure of the N2.

function mean_N2_fig(title)

global theta  x_spacing
global p_y_grid p_z_grid w_z_grid
global flux time N2 slice z_domain g alpha

N2_levels     = [ 1e-7,2e-7,4e-7,6e-7,8e-7,10e-7,12e-7,14e-7,16e-7,20e-7] ;
N2_labels     = N2_levels ;
N2_labels = 'manual' ;


mask  = find(abs(theta) < eps) ;
temp = NaN.*ones(size(mask)) ;
theta(mask) = temp ;

N2obs = (g*alpha).*d_dn(theta,'z',p_z_grid,z_domain) ;

% Get max, min values and remove land from slices.
mask  = find(isnan(N2obs)) ;
% Get max values
temp         = -99.*ones(size(mask)) ;
N2obs(mask)  = temp ;
max_N2obs    = max(max(N2obs)) 

% Get min values
temp         = 99.*ones(size(mask)) ;
N2obs(mask)  = temp ;
min_N2obs    = min(min(N2obs))  


figure
subplot(2,1,1)
hold on
plotslice(N2obs,'yz',slice,p_y_grid,w_z_grid,N2_levels,N2_labels,'-') ;
hold on
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;

t = text(0,350,title) ;
set(t,'FontSize',18) ;
%caxis([-.5,1]) ;
%shading flat
%h1 = colorbar ;

subplot(2,1,2)
hold on
plotmean(N2obs,'yz',x_spacing,p_y_grid,w_z_grid,N2_levels,N2_labels,'-') ;
hold on
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;
hold off
set(get(gca,'Title'), 'FontSize',14 );
%caxis([-.5,1]) ;
%shading flat
%h2 = colorbar ;


set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

return

