% Script to print out picture of an xy slice of PV and a PV N2 scatter diagram.
% Prints out a 
% Author Tom, 5/10/95. 

clear
clear global
close all

global f N2 alpha g c rho_bar 
global theta u v w q
global x_spacing y_spacing z_spacing this_path NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid
global x_domain y_domain z_domain
global Half_flux time cooling_width cooling_offset

% Plot cross section of this slice
slice_no =  8;

% Titles for each sub plot.
title1 = 'PV field' ;

% Iterations.
Itr_no = [12960 14400] ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ; 
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

% Read parameter file.
param_file_name =   'Expt16' ;
feval(param_file_name) ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

folder = Itr_no(1) ;
time    = folder * 60 ;
this_path_t = this_path ;
this_path   = [this_path_t,'/',num2str(folder,5)] ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   read_fields(1,0,1,1,1,0,this_path) ;
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;
clear temp

PVdepth    = num2str(PV_z_grid(slice_no)) ;

q_slice   = getxy(q,slice_no) ;

% Get max, min values and remove land from PV.
mask  = find(isnan(q_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
max_q          = max(max(q_slice))

% Get min values
temp  = 99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
min_q          = min(min(q_slice))

% Remove land.
temp  = NaN.*ones(size(mask)) ;
q_slice(mask)  = temp ;

% Flip so that North is to the top.
q_slice = flipud(q_slice) ;

figure
subplot(2,1,1)
pcolor(PV_x_grid./1000,PV_y_grid./1000,q_slice) ;
shading flat
caxis([-0.25,1.5]) ;
colorbar('vert') ;
colormap(hsv)
caxis([-0.25 1.5]) ;
hold on
title([title1,' at ',PVdepth,'m depth.'],'FontSize',14) ;
xlabel('Along channel distance (km).') ;
ylabel('Across channel distance (km).') ;
set(gca,'AspectRatio',[x_domain/y_domain,1]) ;


% Do 2nd figure, a day later.

folder = Itr_no(2) ;
time    = folder * 60 ;
this_path   = [this_path_t,'/',num2str(folder,5)] ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   read_fields(1,0,1,1,1,0,this_path) ;
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;
clear temp

PVdepth    = num2str(PV_z_grid(slice_no)) ;

q_slice   = getxy(q,slice_no) ;

% Get max, min values and remove land from PV.
mask  = find(isnan(q_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
max_q          = max(max(q_slice))

% Get min values
temp  = 99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
min_q          = min(min(q_slice))

% Remove land.
temp  = NaN.*ones(size(mask)) ;
q_slice(mask)  = temp ;

% Flip so that North is to the top.
q_slice = flipud(q_slice) ;

subplot(2,1,2)
pcolor(PV_x_grid./1000,PV_y_grid./1000,q_slice) ;
shading flat
caxis([-0.25,1.5]) ;
colorbar('vert') ;
colormap(hsv)
caxis([-0.25 1.5]) ;
hold on
%title([title1,' at ',PVdepth,'m depth.'],'FontSize',14) ;
xlabel('Along channel distance (km).') ;
ylabel('Across channel distance (km).') ;
set(gca,'AspectRatio',[x_domain/y_domain,1]) ;

orient tall



