% Script to print out picture of a north south slice of the 2D model for John.
%
% Author Tom, 27/11/95. 

clear
clear global
close all
whos

global f N2 alpha g c rho_bar 
global x_spacing y_spacing z_spacing this_path NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid xvort_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid xvort_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid xvort_z_grid
global x_domain y_domain z_domain
global Half_flux time Initial_temps cooling_width cooling_offset
global u v w

% Plot cross section of this slice
slice = 1 ;

% timestep for displacement vectors (seconds).
step = 1800 ;

% Titles for each sub plot.
title1 = 'Temperature and flow' ;
title2 = 'PV and flow' ;
title3 = 'Temperature and absolute momentum' ;
title4 = 'PV' ;

% Positions of plots.
margin = 0.1 ;
key_height = 0.03 ;
sub_plot_ht = (1-key_height-2*margin)/1.8 ;
sub_plot_width = (1-4*margin) ;
pos = [2*margin                margin+1.1*sub_plot_ht sub_plot_width sub_plot_ht ;
       2*margin                margin+0.3*sub_plot_ht sub_plot_width sub_plot_ht ;
       0.35                    margin+0.2*sub_plot_ht 0.3            key_height  ] ;

% vector of plot handles.
h = [0 0 0] ;

% Range of colourbar. 
range = [-0.5 1.5] ;

% Region to zoom in on. (x in km; y in m). reggion is the (approx indices
% and zoom vars control the axis limits.
region = [40:80] ;
zoom_x = [10 20] ;
zoom_y = [-1000 0] ;

% Aspect Ratio. The first number in this expression is the final ratio
% of x to y on the plot.
AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1)) ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ; 
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

% Read parameter file.
param_file_name =   'Expt15ii' ;
feval(param_file_name) ;
Expt_no = [12960,14400] ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

% Get surface fluxes.
flux     = Half_flux.*(tanh((2.*(p_y_grid - cooling_offset))./cooling_width) + 1 ) ;
flux     = [p_y_grid',flux'] ;

% Local variables.
theta_levels = [ 11:0.02:12]-12 ;
theta_labels = [] ;
ang_mom_levels = [0:-y_domain/30:-y_domain].*f ;
ang_mom_labels = [] ;
q_levels     = [ 1.25,1.0,0.5,0.25,0.1,0.01,0] ;
q_labels = [] ; 

% Setup definitions for plotting grids.
abs_grid  = p_y_grid./1000 ;
ord_grid  = p_z_grid(1:NZ) ;
abs_len   = [0,y_domain]./1000 ;
ord_len   = [-z_domain,0] ;
abs_N     = NY ;
ord_N     = NZ ;
new_abs_N = NY ;
new_ord_N = NZ * 2 ;
Grid_type = 0 ;

if( std(diff(abs_grid)) > eps | std(diff(ord_grid)) > eps )
   Grid_type = 1 ;
   x = [abs_grid(1) : (abs_grid(abs_N)-abs_grid(1))/(new_abs_N-1) : abs_grid(abs_N)]  ;
   y = [ord_grid(1) : (ord_grid(ord_N)-ord_grid(1))/(new_ord_N-1) : ord_grid(ord_N)]  ;
   [X,Y] = meshgrid(x,y)   ;
   [old_x,old_y] = meshgrid(abs_grid,ord_grid) ;
else
   [X,Y] = meshgrid(abs_grid,ord_grid) ;
end

% Form subset of full grid to plot velocities if needs be.
y_ext = [1:1:NY] ;
z_ext = [1:1:NZ] ;
temp_y_grid = v_y_grid(y_ext)/1000 ;
temp_z_grid = v_z_grid(z_ext) ;

% Scale for grid in plot.
del_y = 0.5*abs(mean(diff(temp_y_grid)));
del_z = 0.5*abs(mean(diff(temp_z_grid)));

folder = Expt_no(1) ;
time    = folder * 60 ;
this_path_t = this_path ;
this_path   = [this_path,'/',num2str(folder,5)] ;

% Flux switched off after 12960 timesteps.
if(folder > 12960)
   time = 12960*60 ;
end

% Read data using external function readmodel.m. 
% Read temperature (units C).
theta = readmodel('theta.sun.b',this_path,'float32') ;

% Read u (units m/s). 
u = readmodel('u.sun.b',this_path,'float32') ;

% Read v (units m/s). 
v = readmodel('v.sun.b',this_path,'float32') ;

% Read w (units Nm^-2s^-1; divide by -(g*rho_bar) to get m/s, +ve upwards). 
w = readmodel('w.sun.b',this_path,'float32') ;
w = w./(-g*rho_bar) ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;

% get slice required.
q = getyz(q,slice) ;

% Regrid PV if needs be.
if( Grid_type == 1)
   fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
   %q = reshape(q,NY,NZ)' ;
   q = interp2(old_x,old_y,q,X,Y) ;
end

clear temp

% Take slice of data and extract the required data points (a subset of
% the whole set).
new_v_slice = getyz(v,slice) ;
new_v_slice = new_v_slice(z_ext,y_ext);

% Use v mask for the w mean because w=0 both when there is a land cell and a nearby
% boundary.
new_w_slice = getyz(w,slice) ;
new_w_slice = new_w_slice(z_ext,y_ext) ;

% Calculate the distance travelled in a certain time for plot of velocity vectors.
v_max = max(max(new_v_slice))  ;
w_max = max(max(new_w_slice))  ;
new_v_slice = new_v_slice.*step/1000 ;
new_w_slice = new_w_slice.*step ;

[x,y] = meshgrid(temp_y_grid,temp_z_grid)  ;

% Print figures, of theta & ang_mom, flow, PV  and tracer.
figure
h(1) = axes('Position',pos(1,:)) ;
set(h(1),'ColorOrder',[1 1 1]) ;

hold on
plotslice(theta-12,'yz',slice,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
hold on
gg = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(gg,'LineWidth',2) ;
tom_quiver(x,y,new_v_slice,new_w_slice) ;

xlabel('Across channel distance (km).') ;
ylabel('Depth (m).') ;
t = text(zoom_x(1),zoom_y(2)+150,title1) ;
set(t, 'FontSize',12);
set(get(gca,'Title'),'String','') ;
set(gca,'YLim',zoom_y) ;
set(gca,'XLim',zoom_x) ;
set(gca,'AspectRatio',[AsRat,NaN]) ;
set(gca,'Box','on') ;

% PV figure.
h(2) = axes('Position',pos(2,:)) ;
set(h(2),'ColorOrder',[1 1 1]) ;

hold on
pcolor(X,Y,q) ;
hold on
tom_quiver(x,y,new_v_slice,new_w_slice) ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(h,'LineWidth',2) ;

t = text(zoom_x(1),zoom_y(2)+150,title2) ;
set(t,'FontSize',12) ;
caxis([range(1) range(2)]) ;
shading flat
p = get(gca,'Position') ;
temp = gca ;
set(temp,'Position',p) ;
set(get(gca,'Title'),'String','') ;
xlabel('Across channel distance (km).') ;
ylabel('Depth (m).') ;
set(gca,'YLim',zoom_y) ;
set(gca,'XLim',zoom_x) ;
set(gca,'AspectRatio',[AsRat,NaN]) ;
set(gca,'Box','on') ;

orient tall 

% Colorbar
h(3) = axes('Position',pos(3,:)) ;
y = [0,1] ;
x = [range(1):0.01:range(2)] ;
z = [x;x] ;
pcolor(x,y,z) ;
colormap(jet) ;
shading flat
set(h(3),'YTick',[]) ;
title(['Normalised PV [-].']) ;
set(h(3),'Box','on') ;

% Do 2nd plot now.

% Read in list of parameters for this session.
folder = Expt_no(2) ;
time    = folder * 60 ;
this_path   = [this_path_t,'/',num2str(folder,5)] ;

% Read data using external function readmodel.m.
% Read temperature (units C).
theta = readmodel('theta.sun.b',this_path,'float32') ;

% Read u (units m/s).
u = readmodel('u.sun.b',this_path,'float32') ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;

% get slice required.
q = getyz(q,slice) ;

% Regrid PV if needs be.
if( Grid_type == 1)
   fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
   q = interp2(old_x,old_y,q,X,Y) ;
end

% Rough calculation of angular momentum.
fprintf(1,' Calculating angular momentum ... \n') ;
ang_mom = zeros(NY,NZ*NX) ;
temp  = reshape(u,NY,NX*NZ) ;
temp2 = meshgrid(f.*u_y_grid,[1:NX*NZ])' ;
ang_mom = temp - temp2 ;
ang_mom = reshape(ang_mom,NY*NZ,NX) ;
clear temp ;
clear temp2 ;
 
% Print figures, of theta & ang_mom, flow, PV  and tracer.
figure
h(1) = axes('Position',pos(1,:)) ;
set(h(1),'ColorOrder',[1 1 1]) ;

hold on
plotslice(theta-12,'yz',slice,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
hold on
plotslice(ang_mom,'yz',slice,u_y_grid,u_z_grid,ang_mom_levels,ang_mom_labels,':') ;
gg = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(gg,'LineWidth',2) ;

xlabel('Across channel distance (km).') ;
ylabel('Depth (m).') ;
t = text(zoom_x(1),zoom_y(2)+150,title3) ;
set(t, 'FontSize',12);
set(get(gca,'Title'),'String','') ;
set(gca,'YLim',zoom_y) ;
set(gca,'XLim',zoom_x) ;
set(gca,'AspectRatio',[AsRat,NaN]) ;
set(gca,'Box','on') ;

% PV figure.
h(2) = axes('Position',pos(2,:)) ;
set(h(2),'ColorOrder',[1 1 1]) ;

pcolor(X,Y,q) ;
hold on
gg = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
set(gg,'LineWidth',2) ;

t = text(zoom_x(1),zoom_y(2)+150,title4) ;
set(t,'FontSize',12) ;
caxis([range(1) range(2)]) ;
shading flat
p = get(gca,'Position') ;
temp = gca ;
set(temp,'Position',p) ;
set(get(gca,'Title'),'String','') ;
xlabel('Across channel distance (km).') ;
ylabel('Depth (m).') ;
set(gca,'YLim',zoom_y) ;
set(gca,'XLim',zoom_x) ;
set(gca,'AspectRatio',[AsRat,NaN]) ;
set(gca,'Box','on') ;

orient tall

% Colorbar
h(3) = axes('Position',pos(3,:)) ;
y = [0,1] ;
x = [range(1):0.01:range(2)] ;
z = [x;x] ;
pcolor(x,y,z) ;
colormap(jet) ;
shading flat
set(h(3),'YTick',[]) ;
title(['Normalised PV [-].']) ;
set(h(3),'Box','on') ;

