% Script to print out picture of a north south slice.
% Add code to plot figure of analytical solution in this case.
% Add code to show overturning streamfunction too.
% Enter the figure required and the various options are set automatically.
%
% Author Tom, 27/9/95. 

clear
clear global
close all
whos

global f N2 alpha g c rho_bar 
global x_spacing y_spacing z_spacing this_path NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid xvort_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid xvort_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid xvort_z_grid
global x_domain y_domain z_domain
global Half_flux time Initial_temps cooling_width cooling_offset
global u v w

colors = 'gray' ;
%display = 'off' ;
display = 'on' ;

% Get figure required/
fprintf(1,'\n Script to plot out North-South slices from the channel model.\n') ;
fprintf(1,'\n Options :  (1) Figure of symmetric instability expt at day 9,') ;
fprintf(1,'\n            (2) Figure of symmetric instability expt at day 10 (switch-off),') ;
fprintf(1,'\n            (3) Figure of theoretical symmetric instability switch-off expt.,') ;
fprintf(1,'\n            (4) Figure of baroclinic instability expt at day 9,') ;
fprintf(1,'\n            (5) Figure to test the streamfunction works OK (test),') ;
fprintf(1,'\n') ;
opt = input(' Enter the figure required : ') ;
if (opt < 1 | opt > 5 | opt ~= round(opt) )
    fprintf(1,' Enter options 1-5 only.\n\n') ;
    return ;
end

% Set up options.
if (opt == 3)

   slice = 1 ;
   cd /data5/twnh/matlab/2D_channel
   param_file_name =   'Expt15ii' ;
   folder = ['14400'] ;
   region = [40:80] ;
   zoom_x = [10 20] ;
   zoom_y = [-1000 0] ;
   margin = 0.1 ;
   key_height = 0.03 ;
   sub_plot_ht = (1-key_height-2*margin)/3 ;
   sub_plot_width = 0.76 ;
   pos = [2*margin                margin+1.8*sub_plot_ht  sub_plot_width sub_plot_ht ;
          2*margin                margin+0.5*sub_plot_ht  sub_plot_width/2.5 sub_plot_ht ;
          0.5+margin              margin+0.3*sub_plot_ht  sub_plot_width/2.5 sub_plot_ht ] ;
   h = [0 0 0] ;
   title1 = 'Temperature (-), streamfunction (:) and flow' ;
   AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1)) ;

elseif(opt ==1)

   slice = 1 ;
   cd /data5/twnh/matlab/2D_channel
   param_file_name =   'Expt15ii' ;
   folder = ['12960'] ;
   region = [40:80] ;
   zoom_x = [10 20] ;
   zoom_y = [-1000 0] ;
   AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1)) ;
   margin         = 0.1  ;
   sub_plot_width = 0.70 ;
   sub_plot_ht    = sub_plot_width/AsRat ;
   pos = [0.12 margin+2.2*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.12 margin+1.1*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+1.25*sub_plot_ht 0.03           0.20        ;
          0.12 margin+0.0*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+0.15*sub_plot_ht 0.03           0.20        ] ;
   h = [0 0 0 0 0] ;
   title1 = '(a) Temperature and flow' ;
   title2 = '(b) PV and flow' ;
   title3 = '(c) Tracer and flow' ;
   range = [-0.5 1.0 -0.5 1.0] ;

elseif(opt ==2)

   slice = 1 ;
   cd /data5/twnh/matlab/2D_channel
   param_file_name =   'Expt15ii' ;
   folder = ['14400'] ;
   region = [40:80] ;
   zoom_x = [10 20] ;
   zoom_y = [-1000 0] ;
   AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1)) ;
   margin      = 0.1 ;
   sub_plot_width = 0.70 ;
   sub_plot_ht    = sub_plot_width/AsRat ;
   pos = [0.12 margin+2.2*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.12 margin+1.1*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+1.25*sub_plot_ht 0.03           0.20        ;
          0.12 margin+0.0*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+0.15*sub_plot_ht 0.03           0.20        ] ;
   h = [0 0 0 0 0] ;
   title1 = '(a) Temperature (-), absolute momentum(:) and flow' ;
   title2 = '(b) PV and flow' ;
   title3 = '(c) Tracer and flow' ;
   range = [-0.5 1.0 -0.5 1.0] ;

elseif(opt ==4)

   slice = 100 ;
   cd /data5/twnh/matlab/channel
   param_file_name =   'Expt16' ;
   folder = ['12960'] ;
   region = [1:120] ;
   zoom_x = [0 30] ;
   zoom_y = [-1000 0] ;
   AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1))/3 ;
   margin      = 0.1 ;
   sub_plot_width = 0.70 ;
   sub_plot_ht    = sub_plot_width/AsRat ;
   pos = [0.12 margin+2.2*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.12 margin+1.1*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+1.25*sub_plot_ht 0.03           0.20        ;
          0.12 margin+0.0*sub_plot_ht  sub_plot_width sub_plot_ht ;
          0.92 margin+0.15*sub_plot_ht 0.03           0.20        ] ;
   h = [0 0 0 0 0] ;
   title1 = '(a) Temperature and flow' ;
   title2 = '(b) PV and flow' ;
   title3 = '(c) Tracer and flow' ;
   range = [-0.5 1.0 -0.5 1.0] ;

else

   slice = 1 ;
   cd /data5/twnh/matlab/2D_channel
   param_file_name =   'Expt20' ;
   folder = ['12960'] ;
   region = [40:80] ;
   zoom_x = [10 20] ;
   zoom_y = [-1000 0] ;
   title1 = '(a) streamfunction' ;
   title2 = '(b) Toms streamfunction' ;
   title3 = '(c) Curts streamfunction' ;
   AsRat = 0.25*1000*(zoom_x(2)-zoom_x(1))/(zoom_y(2)-zoom_y(1)) ;

end

% timestep for displacement vectors (seconds).
step = 1800 ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ; 
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

% Read parameter file.
feval(param_file_name) ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

% Get surface fluxes.
flux     = Half_flux.*(tanh((2.*(p_y_grid - cooling_offset))./cooling_width) + 1 ) ;
flux     = [p_y_grid',flux'] ;

% Local variables.
theta_levels = [ 11:0.02:12]-12 ;
theta_labels = theta_levels ;
theta_labels = 'manual' ;
theta_labels = [] ;
ang_mom_levels = [0:-y_domain/30:-y_domain].*f ;
ang_mom_labels = [] ;
q_levels     = [ 1.25,1.0,0.5,0.25,0.1,0.01,0] ;
q_labels     = [ 1.25,1.0,0.5,0.25,0.1,0.05,0.01,0,-0.01,-0.05,-1.0] ;
q_labels = 'manual' ;
q_labels = [] ; 
trac_levels  = [ 0.998,0.996,0.994,0.992,0.99,0.988,0.986,0.984,0.982,0.98] ;
trac_labels  = []  ;
psi_levels = [-2:0.10:2] ;

% Setup definitions for plotting grids.
abs_grid  = p_y_grid./1000 ;
ord_grid  = p_z_grid(1:NZ) ;
abs_len   = [0,y_domain]./1000 ;
ord_len   = [-z_domain,0] ;
abs_N     = NY ;
ord_N     = NZ ;
new_abs_N = NY ;
new_ord_N = NZ * 2 ;
Grid_type = 0 ;

if( std(diff(abs_grid)) > eps | std(diff(ord_grid)) > eps )
   Grid_type = 1 ;
   x = [abs_grid(1) : (abs_grid(abs_N)-abs_grid(1))/(new_abs_N-1) : abs_grid(abs_N)]  ;
   y = [ord_grid(1) : (ord_grid(ord_N)-ord_grid(1))/(new_ord_N-1) : ord_grid(ord_N)]  ;
   [X,Y] = meshgrid(x,y)   ;
   [old_x,old_y] = meshgrid(abs_grid,ord_grid) ;
else
   [X,Y] = meshgrid(abs_grid,ord_grid) ;
end

% Form subset of full grid to plot velocities if needs be.
y_ext = [1:1:NY] ;
z_ext = [1:1:NZ] ;
temp_y_grid = v_y_grid(y_ext)/1000 ;
temp_z_grid = v_z_grid(z_ext) ;

% Scale for grid in plot.
del_y = 0.5*abs(mean(diff(temp_y_grid)));
del_z = 0.5*abs(mean(diff(temp_z_grid)));

% Read in list of parameters for this session. 
time    = str2num(folder) * 60 ;
this_path   = [this_path,'/',folder] ;

% Flux switched off after 12960 timesteps.
if(folder > 12960)
   time = 12960*60 ;
end

% Read data using external function readmodel.m. 
% Read temperature (units C).
theta = readmodel('theta.sun.b',this_path,'float32') ;

% Read u (units m/s). 
u = readmodel('u.sun.b',this_path,'float32') ;

% Read v (units m/s). 
v = readmodel('v.sun.b',this_path,'float32') ;

% Read w (units Nm^-2s^-1; divide by -(g*rho_bar) to get m/s, +ve upwards). 
w = readmodel('w.sun.b',this_path,'float32') ;
w = w./(-g*rho_bar) ;

% Read in tracer.
trac = readmodel('salt.sun.b',this_path,'float32') ;

% Normalise tracer values.
trac = (trac - max(max(trac)) + 0.5) .*2 ;

% get slice required.
trac = getyz(trac,slice) ;

% Regrid tracer if needs be.
if( Grid_type == 1)
   fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
   %trac = reshape(trac,NY,NZ)' ;
   trac    = interp2(old_x,old_y,trac,X,Y) ;
end

% Get streamfunction. 
stream_fn = psi./1e6 ;
[old_xp,old_yp] = meshgrid(xvort_y_grid./1000,xvort_z_grid) ;
old_stream_fn = stream_fn*1e6/x_domain ;
stream_fn = interp2(old_xp,old_yp,stream_fn,X,Y) ;

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;

% get slice required.
q = getyz(q,slice) ;
old_q = q ;

% Regrid PV if needs be.
if( Grid_type == 1)
   fprintf(1,' Regridding %d data ... \n',new_abs_N*new_ord_N) ;
   %q = reshape(q,NY,NZ)' ;
   q = interp2(old_x,old_y,q,X,Y) ;
end

clear temp

% Rough calculation of angular momentum.
fprintf(1,' Calculating angular momentum ... \n') ;
ang_mom = zeros(NY,NZ*NX) ;
temp  = reshape(u,NY,NX*NZ) ;
temp2 = meshgrid(f.*u_y_grid,[1:NX*NZ])' ;
ang_mom = temp - temp2 ;
ang_mom = reshape(ang_mom,NY*NZ,NX) ;
clear temp ;
clear temp2 ;

% Take slice of data and extract the required data points (a subset of
% the whole set).
new_v_slice = getyz(v,slice) ;
new_v_slice = new_v_slice(z_ext,y_ext);

% Use v mask for the w mean because w=0 both when there is a land cell and a nearby
% boundary.
new_w_slice = getyz(w,slice) ;
new_w_slice = new_w_slice(z_ext,y_ext) ;

% Calculate the distance travelled in a certain time for plot of velocity vectors.
v_max = max(max(new_v_slice))  ;
w_max = max(max(new_w_slice))  ;
new_v_slice = new_v_slice.*step/1000 ;
new_w_slice = new_w_slice.*step ;

[x,y] = meshgrid(temp_y_grid,temp_z_grid)  ;

% Print figures, of theta & ang_mom, flow, PV  and tracer.
if( opt == 1 | opt == 2 | opt == 4 )
   figure
   un = get(gcf, 'PaperUnits') ;
   set(gcf, 'PaperUnits','centimeters') ;
   set(gcf, 'PaperPosition', [3, 3, 15, 20]) ;
   set(gcf, 'PaperUnits',un) ;

   set(gcf,'Visible',display) ;
   h(1) = axes('Position',pos(1,:)) ;
   set(h(1),'ColorOrder',[1 1 1]) ;

   plotslice(theta-12,'yz',slice,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
   hold on
   if(opt == 2)
      plotslice(ang_mom,'yz',slice,u_y_grid,u_z_grid,ang_mom_levels,ang_mom_labels,':') ;
   end
   h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
   set(h,'LineWidth',2) ;
   tom_quiver(x,y,new_v_slice,new_w_slice) ;

   xlabel('Across channel distance (km)') ;
   ylabel('Depth (m)') ;
   t = text(zoom_x(1),zoom_y(2)+150,title1, 'FontSize',12) ;
   set(get(gca,'Title'),'String','') ;
   set(gca,'YLim',zoom_y) ;
   set(gca,'XLim',zoom_x) ;
   set(gca,'AspectRatio',[AsRat,NaN]) ;
   set(gca,'Box','on') ;
   set(gca,'FontSize',10) ;
   kids = get(gca,'Children') ;
   set(kids(4:32),'Linewidth',1) ;
   set(gca,'xgrid','off') ;
   set(gca,'ygrid','off') ;

% PV figure.
   h(2) = axes('Position',pos(2,:)) ;
   set(h(2),'ColorOrder',[1 1 1]) ;
   
   hold on
   pcolor(X,Y,q) ;
   hold on
   tom_quiver(x,y,new_v_slice,new_w_slice) ;
   h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
   set(h,'LineWidth',2) ;

   t = text(zoom_x(1),zoom_y(2)+150,title2, 'FontSize',12) ;
   caxis([range(1) range(2)]) ;
   shading flat
   p = get(gca,'Position') ;
   set(get(gca,'Title'),'String','') ;
   xlabel('Across channel distance (km)') ;
   ylabel('Depth (m)') ;
   set(gca,'YLim',zoom_y) ;
   set(gca,'XLim',zoom_x) ;
   set(gca,'AspectRatio',[AsRat,NaN]) ;
   set(gca,'Box','on') ;
   set(gca,'FontSize',10) ;

% Tracer figure.
   h(4) = axes('Position',pos(4,:)) ;
   set(h(4),'ColorOrder',[1 1 1]) ;
   hold on
   pcolor(X,Y,trac) ;
   hold on
   %contour(X,Y,stream_fn,psi_levels,'--') ;
   tom_quiver(x,y,new_v_slice,new_w_slice) ;
   h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'w--') ;
   set(h,'LineWidth',2) ;
   t=text(zoom_x(1),zoom_y(2)+150,title3, 'FontSize',12) ;
   caxis([range(3) range(4)]) ;
   shading flat
   set(get(gca,'Title'), 'FontSize',12 );
   xlabel('Across channel distance (km)', 'FontSize', 12) ;
   ylabel('Depth (m)', 'FontSize', 12) ;
   set(get(gca,'Title'),'String','') ;
   set(gca,'YLim',zoom_y) ;
   set(gca,'XLim',zoom_x) ;
   set(gca,'AspectRatio',[AsRat,NaN]) ;
   set(gca,'Box','on') ;
   set(gca,'FontSize',10) ;

% Colorbars.
   h(3) = axes('Position',pos(3,:)) ;
   x = [0,1] ;
   y = [range(1):0.01:range(2)] ;
   z = [y',y'] ;
   pcolor(x,y,z) ;
   shading flat
   set(h(3),'XTick',[]) ;
   set(h(3),'Box','on') ;
   set(gca,'FontSize',10) ;

   h(5) = axes('Position',pos(5,:)) ;
   x = [0,1] ;
   y = [range(3):0.01:range(4)] ;
   z = [y',y'] ;
   pcolor(x,y,z) ;
   shading flat
   set(h(5),'XTick',[]) ;
   set(h(5),'Box','on') ;
   set(gca,'FontSize',10) ;

   colormap(colors) ;
end

if (opt == 3)
% Include figure of result from analytical solution.
% First fit straight line to H over middle 3rd of channel.

   one_D_H = mixed_layer(flux(:,2),N2,time)' ;
   p = polyfit(p_y_grid(region),one_D_H(region),1) ;
   
   Hy = -p(1) ;
   H_zero = polyval(p,zoom_x(1)) ; 

   theta_temp = getyz(theta,1) ;
   u_temp     = getyz(u,1) ;

   mask = find(theta < 10*eps) ;
   theta(mask) = 1000*ones(size(mask)) ;

% Add on real plots of 2D fields.
   theta_pro = theta_temp(:,60) ;
   u_pro     = u_temp(:,60) ;

% Get ref temp for analytic calc.
   pp = csapi(p_z_grid,theta_pro) ;
   theta_ref = fnval(pp,-1000) - 0.05 ; 

   symmetric(H_zero,Hy,sqrt(N2),theta_ref,zoom_x,zoom_y) ;

% Now include results from the resolved expt.
   subplot(2,2,3)
   hold on
   plot(theta_pro,p_z_grid,'o') ;
   axis([11.5 11.8 -1000 0]) ;

   subplot(2,2,4)
   hold on
   plot(u_pro,p_z_grid,'o') ;
   axis([-0.10 0.2 -1000 0]) ;
end

% Test streamfn is working OK.
if(opt == 5)

   figure
   set(gcf,'Visible',display) ;
% Reshape psi to normal protocol.
   stream_fn2 = reshape(old_stream_fn',NY*NZ,1) ;

% Get velocities from psi.
   psi_v = - d_dn(stream_fn2,'z',xvort_z_grid,z_domain) ;
   psi_w =   d_dn(stream_fn2,'y',xvort_y_grid,y_domain) ;

% Take slice of data and extract the required data points (a subset of
% the whole set).
   new_v_slice = getyz(psi_v,slice) ;
   new_v_slice = new_v_slice(z_ext,y_ext);

% Use v mask for the w mean because w=0 both when there is a land cell and a nearby
% boundary.
   new_w_slice = getyz(psi_w,slice) ;
   new_w_slice = new_w_slice(z_ext,y_ext) ;

% Calculate the distance travelled in a certain time for plot of velocity vectors.
   v_max = max(max(new_v_slice))  ;
   w_max = max(max(new_w_slice))  ;
   new_v_slice = new_v_slice.*step/1000 ;
   new_w_slice = new_w_slice.*step ;

   subplot(2,1,1)
   contour(X,Y,stream_fn,psi_levels,'-') ;
   hold on
   xlabel('Across channel distance (km)', 'FontSize', 12) ;
   tom_quiver(x,y,new_v_slice,new_w_slice) ;
   hold on
   ylabel('Depth (m)', 'FontSize', 12) ;
   t = text(zoom_x(1),zoom_y(2)+150,title2, 'FontSize',12) ;
   set(t, 'FontSize',12);
   set(get(gca,'Title'),'String','') ;
   set(gca,'YLim',zoom_y) ;
   set(gca,'XLim',zoom_x) ;
   set(gca,'AspectRatio',[AsRat,NaN]) ;

% Compare with Curtis' streamfunction.
   curt_psi = readmodel('psi.sun.b',this_path,'float32') ;
   curt_psi = curt_psi./x_domain  ;
   
% Get velocities from psi.

% Need to scale curt's psi by some factor here - can't remember what it is.
   psi_v = - d_dn(curt_psi,'z',xvort_z_grid,z_domain) ;
   psi_w =   d_dn(curt_psi,'y',xvort_y_grid,y_domain) ;
   
% Take slice of data and extract the required data points (a subset of
% the whole set).
   new_v_slice = getyz(psi_v,slice) ;
   new_v_slice = new_v_slice(z_ext,y_ext);
   
% Use v mask for the w mean because w=0 both when there is a land cell and a nearby
% boundary.
   new_w_slice = getyz(psi_w,slice) ;
   new_w_slice = new_w_slice(z_ext,y_ext) ;

% Calculate the distance travelled in a certain time for plot of velocity vectors.
   v_max = max(max(new_v_slice))  ;
   w_max = max(max(new_w_slice))  ;
   new_v_slice = new_v_slice.*step/1000 ;
   new_w_slice = new_w_slice.*step ;

   subplot(2,1,2)
   contour(X,Y,stream_fn,psi_levels,'--') ;
   hold on
   xlabel('Across channel distance (km)', 'FontSize', 12) ;
   tom_quiver(x,y,new_v_slice,new_w_slice) ;
   hold on
   ylabel('Depth (m)', 'FontSize', 12) ;
   t = text(zoom_x(1),zoom_y(2)+150,title3, 'FontSize',12) ;
   set(t, 'FontSize',12);
   set(get(gca,'Title'),'String','') ;
   set(gca,'YLim',zoom_y) ;
   set(gca,'XLim',zoom_x) ;
   set(gca,'AspectRatio',[AsRat,NaN]) ;


end

fprintf(1,'\n Peak speeds in the (y,z) directions are [%6.5f, %6.5f] m/s.\n', v_max,w_max) ;

%wysiwyg
