% Script to print out picture of an xy slice of PV and a PV N2 scatter diagram.
%
% Author Tom, 5/10/95. 

clear
clear global
close all

global f N2 alpha g c rho_bar 
global theta u v w q
global x_spacing y_spacing z_spacing this_path NX NY NZ
global u_x_grid v_x_grid w_x_grid p_x_grid PV_x_grid
global u_y_grid v_y_grid w_y_grid p_y_grid PV_y_grid
global u_z_grid v_z_grid w_z_grid p_z_grid PV_z_grid
global x_domain y_domain z_domain
global Half_flux time cooling_width cooling_offset

% Plot cross section of this slice
slice_no =  8;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ; 
True       = 1 ;
False      = 0 ;
secs_in_a_day = 60*60*24 ;

sub_plot_width = 0.55 ; 
sub_plot_ht    = sub_plot_width*(120/200)*(15/20) ;
pos = [0.15  0.43 sub_plot_width sub_plot_ht ;
       0.30  0.1  0.3            0.225       ;
       0.80  0.45 0.03           0.20        ;
       0.70  0.12 0.03           0.20        ] ;
h = [0 0 0 0] ;
range = [-0.2 1.2 -3.5 -1.5 -0.1667 1.3333] ;
title1 = ['(a) Potential vorticity at -671m depth'] ;
title2 = ['(b) PV and N   survey'] ;

% Read parameter file.
cd /data5/twnh/matlab/channel
param_file_name =   'Expt16' ;
feval(param_file_name) ;

% Define grids.
setup_grids(x_spacing,y_spacing,z_spacing) ;

% Get surface fluxes.
flux     = Half_flux.*(tanh((2.*(p_y_grid - cooling_offset))./cooling_width) + 1 ) ;
flux     = [p_y_grid',flux'] ;

folder = input(' Enter the iteration number of the dump to process : ','s') ;
time    = str2num(folder) * 60 ;
this_path   = [this_path,'/',folder] ;

% Flux switched off after 12960 timesteps.
if(folder > 12960)
   time = 12960*60 ;
end

% Get PV. This function also calculates the vertical vorticity, the RiNo and delta
% (non-hydrostatic parameter) for free !  These are written to disk for later use.
temp = [this_path,'/','q.mat'] ;
if( fopen(temp) == -1)
   read_fields(1,0,1,1,1,0,this_path) ;
   PV ;
   fid = fopen(temp,'w') ;
   fwrite(fid,q,'float32') ;
else
   read_fields(1,0,0,0,0,0,this_path) ;
   fprintf(1,' Retrieving PV from disk ... \n') ;
   fid = fopen(temp,'r') ;
   q = fread(fid,[NY*NZ,NX],'float32') ;
end
fclose(fid) ;
q = -q.*g./(f.*N2) ;
clear temp

PVdepth    = num2str(PV_z_grid(slice_no)) ;
N2depth    = num2str(w_z_grid(slice_no)) ;

% Just calculate N2 in the vicinity of the horizontal slice.
fprintf(1,' Calculating N2 ... ') ;
theta_sub  = theta([(slice_no-2)*NY+1:((slice_no)*NY)],:) ;
mask  = find(abs(theta_sub) < eps) ;
temp = NaN.*ones(size(mask)) ;
theta_sub(mask) = temp ;
grid_sub   = [p_z_grid(slice_no-1),p_z_grid(slice_no)] ;
domain_sub = 500 ;
temp_NZ = NZ ;
NZ = 2 ;
N2obs = (g*alpha).*d_dn(theta_sub,'z',grid_sub,domain_sub)./N2 ;

% Regrid N2 to the same points as PV values for scatter plot.
regrid(N2obs,'x',p_x_grid,PV_x_grid,x_domain) ;
regrid(N2obs,'y',p_y_grid,PV_y_grid,y_domain) ;
N2_slice =  getxy(N2obs,2) ;
NZ = temp_NZ ;

q_slice   = getxy(q,slice_no) ;

% Get max, min values and remove land from N2.
mask  = find(isnan(N2_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
N2_slice(mask)  = temp ;
max_N2          = max(max(N2_slice))

% Get min values
temp  = 99.*ones(size(mask)) ;
N2_slice(mask)  = temp ;
min_N2          = min(min(N2_slice))

% Remove land.
temp  = NaN.*ones(size(mask)) ;
N2_slice(mask)  = temp ;

% Get max, min values and remove land from PV.
mask  = find(isnan(q_slice)) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
max_q          = max(max(q_slice))

% Get min values
temp  = 99.*ones(size(mask)) ;
q_slice(mask)  = temp ;
min_q          = min(min(q_slice))

% Remove land.
temp  = NaN.*ones(size(mask)) ;
q_slice(mask)  = temp ;

% Load in survey results from he CM-5 : these results are in m^3 for the whole
% fluid volume. See diag.F on the CM-5.
temp = [this_path,'/','TSsurvey.sbin.',folder] ;
if( fopen(temp) == -1)
   fprintf(1,' Cannot find file [%s].',temp) ;
   return ;
else
fprintf(1,' Loading in survey results from the CM-5') ;
   fid = fopen(temp,'r') ;
   pad                     = fread(fid,1,'int') ;
   bins                    = fread(fid,[1,2],'int') ;
   pad                     = fread(fid,1,'int') ;
   pad                     = fread(fid,1,'int') ;
   hits                    = fread(fid,[bins(1)+1,bins(2)+1],'float32') ;
   fclose(fid) ;
end
del     = 5/90 ;
q_bins = [-0.5:del:2.0] ;
N2_bins = [-0.5:del:2.0] ;
orig_hits = hits ;

% remove no hits and normalise.
sum_hits = sum(sum(hits)) ;
temp = find(hits <2e9) ;
hits(temp) = ones(size(temp)).*NaN ;
hits = hits./sum_hits ;

% Flip so that North is to the top.
q_slice = flipud(q_slice) ;

figure
un = get(gcf, 'PaperUnits') ;
set(gcf, 'PaperUnits','centimeters') ;
set(gcf, 'PaperPosition', [3, 3, 15, 20]) ;
set(gcf, 'PaperUnits',un) ;

colormap(jet)

h(1) = axes('Position',pos(1,:)) ;
pcolor(PV_x_grid./1000,PV_y_grid./1000,q_slice) ;
shading flat
caxis([range(1) range(2)]) ;
hold on
xlabel('Along channel distance (km)', 'FontSize',12) ;
ylabel('Across channel distance (km)', 'FontSize',12) ;
set(gca,'Box','on') ;
set(gca,'FontSize',10) ;
set(gca,'XLim',[0 50]) ;
set(gca,'YLim',[0 30]) ;

h(2) = axes('Position',pos(2,:)) ;
ylabel('Normalised PV', 'FontSize', 12) ;
xlabel('Normalised N', 'FontSize', 12) ;
text(1.01,-0.37,'2','FontSize',8) ;
axis([range(5) range(6) range(5) range(6)]) ;
hold on
pcolor(N2_bins,q_bins,log10(hits')) ;
caxis([range(3) range(4)])
plot([-2 2],[-2 2],'k-') ;
set(gca,'FontSize',10) ;
set(gca,'XTick',[0 0.2 0.4 0.6 0.8 1 1.2]) ;
set(gca,'YTick',[0 0.2 0.4 0.6 0.8 1 1.2]) ;

% Annotations, colorbar etc.
h(3) = axes('Position',pos(3,:)) ;
x = [0,1] ;
y = [range(1):0.01:range(2)] ;
z = [y',y'] ;
pcolor(x,y,z) ;
shading flat
set(h(3),'XTick',[]) ;
set(h(3),'Box','on') ;
set(h(3),'FontSize',10) ;

h(4) = axes('Position',pos(4,:)) ;
x = [0,1] ;
y = [range(3):0.01:range(4)] ;
z = [y',y'] ;
pcolor(x,y,z) ;
shading flat
set(h(4),'XTick',[]) ;
set(h(4),'YTick',[]) ;
set(h(4),'Box','on') ;
text(-1.3,-3.7,'Normalised','FontSize',12) ;
text(-0.7,-3.9,'Volume','FontSize',12) ;
set(gca,'FontSize',10) ;
text(-1.9,-2.0,'10') ;
text(-1.9,-3.0,'10') ;
text(-1.0,-1.9,'-2', 'FontSize',8) ;
text(-1.0,-2.9,'-3', 'FontSize',8) ;

subplot(h(1)) ;
text(0,32,title1,'FontSize',12) ;

subplot(h(2)) ;
text(-0.20,1.45,title2,'FontSize',12) ;
text(0.62, 1.52,'2','FontSize',8) ;

wysiwyg
fprintf(1,'\n\n') ;
