% Script to read and display a figure from the ACCP poster.      
% This function displays 3 contour plots of the temperature from the 
% channel model, Expt1viii. These are at days 3, 6 and 9.
% 
% Author : tom 24/4/95.

% Setup variables for plot; model constants and grids etc.

clear global
clear
close all

global p_x_grid p_y_grid p_z_grid zvort_x_grid zvort_y_grid zvort_z_grid
global theta zvort x_spacing y_spacing z_spacing this_path NX NY NZ
global x_domain y_domain z_domain f

% Define whether you want a contour or colour map here (0 = colours). 
% Colour mapping is slow. Also define whether or not 2 figures are printed, 
% or everything on one page. Also define how each subplot is stretched from 
%  the matlab default.
option = 0 ;
adjustment = [1,1,1,1] ;

cd /data5/twnh/matlab/channel
Expt1
setup_grids(x_spacing, y_spacing, z_spacing) ;
slice_no = 19 ;
days = [3,6,9] ;

margin = 0.1 ;
sub_plot_width = 0.55 ;
sub_plot_ht    = sub_plot_width * (120/200) * (15/20) ; 
pos = [0.15  margin+2.3*sub_plot_ht  sub_plot_width sub_plot_ht ;
       0.15  margin+1.15*sub_plot_ht  sub_plot_width sub_plot_ht ;
       0.15  margin+0.0*sub_plot_ht  sub_plot_width sub_plot_ht ;
       0.80  margin+1.35*sub_plot_ht 0.03           0.15        ] ;
h = [0 0 0 0] ;
range = [11.6 12] ;

figure
un = get(gcf, 'PaperUnits') ;
set(gcf, 'PaperUnits','centimeters') ;
set(gcf, 'PaperPosition', [3, 3,  15,  20]) ;
set(gcf, 'PaperUnits',un) ;

colormap(jet)

% Read in temperature field at days 3, 6 and 9 from disk.
for i = 1:size(days,2)
   path = [this_path,'/',num2str(days(i)*60*24,5)] ;
   theta = readmodel('theta.sun.b',path,'float32') ;
   theta_slice = getxy(theta,slice_no) ;
   clear theta

% Flip slice so the cooled region is to the North.
   theta_slice = flipud(theta_slice) ;

   theta_depth    = num2str(p_z_grid(slice_no)) ;

% Get max, min values and remove land from slices.
   mask  = find(theta_slice < 2 ) ;
% Get max values
   temp  = -99.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;
   max_theta         = max(max(theta_slice));

% Get min values
   temp  = 99.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;
   min_theta         = min(min(theta_slice))

% Remove land.
   temp  = NaN.*ones(size(mask)) ;
   theta_slice(mask)  = temp ;

    h(i) = axes('Position',pos(i,:)) ;

   if(option == 1)
      c = contour(p_x_grid./1000,p_y_grid./1000,theta_slice,6) ;
   else
      pcolor(p_x_grid./1000,p_y_grid./1000,theta_slice) ;
      shading flat
      caxis([range(1) range(2)]) ;
      set(gca,'AspectRatio',[x_domain/y_domain,1]) ;
   end
   hold on
   sub_title = ['Day ',num2str(days(i))] ;
   text(5,5,sub_title,'FontSize', 12) ;
   set(gca,'FontSize',10) ;
   set(gca,'Box','on') ;
   set(gca,'XLim',[0 50]) ;
   set(gca,'YLim',[0 30]) ;

end

% Colorbar 
h(4) = axes('Position',pos(4,:)) ;
x = [0,1] ;
y = [range(1):0.01:range(2)] ;
z = [y',y'] ;
pcolor(x,y,z) ;
shading flat
set(h(4),'XTick',[]) ;
set(h(4),'Box','on') ;
set(gca,'FontSize',10) ;
text(-1.3,11.55,'Surface','FontSize',12) ;
text(-2.1,11.48,'Temperature','FontSize',12) ;
text(-0.3,11.41,'(C)','FontSize',12) ;
set(gca,'XLim',[0 1]) ;
set(gca,'YLim',[range(1) range(2)]) ;
set(gca,'YTickLabels',[11.6 11.7 11.8 11.9 12]) ;
set(gca,'YTick',[11.6 11.7 11.8 11.9 12]) ;

subplot(h(2)) ;
ylabel('Across channel distance (km)','FontSize',12) ;

subplot(h(3)) ;
xlabel('Along channel distance (km)','FontSize',12) ;

wysiwyg    
