% Script to plot figure of the cooling function used in Expt1.
% For ACCP poster.
%
% Author Tom, 28/4/95.

clear 
close all

figure
h = axes('Position',[0.20 0.20 0.7 0.7]) ;
un = get(gcf, 'PaperUnits') ;
set(gcf, 'PaperUnits','centimeters') ;
set(gcf, 'PaperPosition', [3, 10, 8.3, 8.3]) ;
set(gcf, 'PaperUnits',un) ;

x = [0:0.05:30] ;
H = 400.*(tanh(2*((x-15))./10)+1) ;

plot(x,H,'-', 'LineWidth',1.0) ;

xlabel('Across channel distance (km)', 'FontSize',12) ;
ylabel('Heat flux (Wm    )', 'FontSize', 12) ;
tt = text(-5.5,610,'-2','FontSize',9,'Rotation',90) ;

set(gca,'AspectRatio',[1.5,NaN]) ;
set(gca, 'FontSize', 10) ;

grid on
wysiwyg
