% Script to plot figure of the tinst fit from the paper.
%
% Author Tom, 4/1/96. 

clear 
close all

% Data from Excel sheet.
model_res = [1.65, 1.92 ;
             1.50, 1.89 ;
             1.81, 1.99 ;
             1.65, 1.88 ;
             1.96, 2.19 ;
             1.65, 1.92 ;
             2.11, 2.37 ;
             2.26, 2.46 ;
             1.35, 1.61 ;
             2.11, 2.44 ;
             2.11, 2.31 ;
             1.96, 2.16 ;
             2.11, 2.29 ;
             1.65, 1.93 ] ;

new_pred  = [2.26, 2.51 ;
             1.35, 1.61 ] ;

Stone_pred = [2.26, 2.20 ;
              1.35, 1.93 ] ;

figure
h = axes('Position',[0.20 0.20 0.75 0.75]) ;
un = get(gcf, 'PaperUnits') ;
set(gcf, 'PaperUnits','centimeters') ;
set(gcf, 'PaperPosition', [3, 10, 8.3, 8.3]) ;
set(gcf, 'PaperUnits',un) ;

plot(model_res(:,1),  model_res(:,2), 'wo',  ...
      new_pred(:,1),   new_pred(:,2), 'w-',  ...
    Stone_pred(:,1), Stone_pred(:,2), 'w--') ;

% Fonts.
%fnt1 = 'Times-Italic' ;
%fnt2 = 'Helvetica' ;
fnt1 = 'Helvetica' ;
fnt2 = 'Symbol' ;

% Y label
y1 = text(1.00,1.60,'log    (          .f)', 'FontSize',12,'FontName',fnt1,'Rotation',90) ;
y2 = text(1.03,1.78,'10', 'FontSize',10,'FontName',fnt1,'Rotation',90) ;
y3 = text(1.00,1.96,'t', 'FontSize',12,'FontName',fnt2,'Rotation',90) ;
y4 = text(1.03,2.01,'model', 'FontSize',10,'FontName',fnt1,'Rotation',90) ;

% X label
x1 = text(1.55,0.75,'log    (L       /l    )', 'FontSize',12,'FontName',fnt1) ;
x2 = text(1.65,0.70,'10', 'FontSize',10,'FontName',fnt1) ;
x3 = text(1.82,0.70,'zone   rot', 'FontSize',10,'FontName',fnt1) ;

axis([1.2 2.4 1 3]) ;
set(gca, 'XTick', [1.2,1.6,2,2.4] ) ;
set(gca, 'XTickLabels', [1.2,1.6,2,2.4] ) ;

set(gca, 'FontSize', 10) ;

grid on
wysiwyg
