% Script to test the tsg data for a diurnal cycle following reviewer's comments. 

% Author : twnh, sep '96.

close all
clear

secs_in_an_hr = 60*60 ;
secs_in_a_day = 60*60*24 ;
secs_in_a_yr  = secs_in_a_day * 365 ;

cd /data5/twnh/matlab/Instability

if(exist('raw_data') == 0)
  file = '/data8/twnh/VIVALDI/tsgVIV.ascii.times' ;
  raw_data = read(file,'%g %g %g %g',1,-1,2) ;
end

% Extract raw_x and raw_rho from the data. Convert x to SI from km
raw_x     = raw_data(:,2)*1000 ; ;
raw_rho   = raw_data(:,3) ;
raw_times = raw_data(:,4) ;
raw_no    = size(raw_data,2) ;

time_of_day = rem(raw_times,secs_in_a_day)./secs_in_an_hr ;

plot(time_of_day,raw_rho,'.') ;

axis([0,24,26,27.5]) ;

%temp1 = find(raw_rho = -999.00)
%pp = csapi(raw_times,raw_rho) ;
%temp2 = fnval(pp,temp1) ;
%raw_rho(temp1) = temp2 ;

% Remove trend in sigma over each day.
temp1 = find(time_of_day == 0.25) ;
temp2 = temp1 - 1 ;
temp3 = [0.25:0.5:23.75]'./24 ;
anomalies = [] ;

% Good data for these days (should interpolate over absent data values really).
for i = 19:30
   start_sig = raw_rho(temp1(i)) ;
   end_sig   = raw_rho(temp2(i+1)) ;
   trend     = start_sig + (temp3 .* (end_sig - start_sig)) ;
   anomaly   = (raw_rho([temp1(i):temp1(i)+47]) - trend) ;
   anomalies = [anomalies,anomaly] ;
end

temp3 = temp3.*24 ;

plot(temp3,anomalies,'.')
hold on

mean_anom = mean(anomalies')' ;
std_anom  =  std(anomalies')' ;

plot(temp3,mean_anom, '-') ;
plot(temp3,mean_anom+std_anom, '--') ;
plot(temp3,mean_anom-std_anom, '--') ;

xlabel('Time of day (hr)') ;
ylabel('Anomalous surface density (kg/m^3)') ;
