% Displays a plot of theta and angular momentum.

function theta_fig(title)

global u_y_grid p_y_grid
global u_z_grid p_z_grid
global theta u ang_mom flux time
global x_domain f x_spacing N2 slice y_domain

theta_levels = [ 8:0.05:12] ;
theta_labels = theta_levels ;
%theta_labels = 'manual' ;
ang_mom_levels = [0:-y_domain/20:-y_domain].*f ;
ang_mom_labels = ang_mom_levels ;
%ang_mom_labels = 'manual' ;

figure
subplot(2,1,1)
plotslice(theta,'yz',slice,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
hold on
plotslice(ang_mom,'yz',slice,u_y_grid,u_z_grid,ang_mom_levels,ang_mom_labels,':') ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(h,'LineWidth',2) ;
hold off
t = text(0,350,title) ;
set(t,'FontSize',18) ;

subplot(2,1,2)
plotmean(theta,'yz',x_spacing,p_y_grid,p_z_grid,theta_levels,theta_labels,'-') ;
hold on
plotmean(ang_mom,'yz',x_spacing,u_y_grid,u_z_grid,ang_mom_levels,ang_mom_labels,':') ;
h = plot(flux(:,1)./1000,mixed_layer(flux(:,2),N2,time),'--') ;
set(h,'LineWidth',2) ;
hold off

set(gcf,'PaperPosition',[0.5 0.5 7.5 10]) ;

return
