% Displays a bird's eye view of vertical vorticity and theta.

function vort_theta_fig(title_text)

global p_x_grid p_y_grid p_z_grid zvort_x_grid zvort_y_grid zvort_z_grid
global theta zvort 
global f

slice_no = 19 ;
vortdepth    = num2str(zvort_z_grid(slice_no)) ;
thetadepth   = num2str(p_z_grid(slice_no)) ;

zvort_slice  = getxy(zvort,slice_no) ;
theta_slice  = getxy(theta,slice_no) ;

% Get max, min values and remove land from theta and zvort.
mask  = find(abs(theta_slice) < eps) ;

% Get max values
temp  = -99.*ones(size(mask)) ;
theta_slice(mask)  = temp ;
max_theta          = max(max(theta_slice))  ;

% Get min values
temp  = 99.*ones(size(mask)) ;
theta_slice(mask)  = temp ;
min_theta          = min(min(theta_slice)) ;

% Remove land.
temp  = NaN.*ones(size(mask)) ;
theta_slice(mask)  = temp ;

% Do zvort now.
mask  = find(isnan(zvort_slice)) ;
% Get max values
temp  = -99.*ones(size(mask)) ;
zvort_slice(mask)  = temp ;
max_zvort         = max(max(zvort_slice)) ;

% Get min values
temp  = 99.*ones(size(mask)) ;
zvort_slice(mask)  = temp ;
min_zvort         = min(min(zvort_slice))  ;

% Remove land.
temp  = NaN.*ones(size(mask)) ;
zvort_slice(mask)  = temp ;

figure
subplot(2,1,1) ;
c = contour(zvort_x_grid./1000,zvort_y_grid./1000,zvort_slice,6) ;
%pcolor(zvort_x_grid./1000,zvort_y_grid./1000,zvort_slice) ;
%shading flat
%caxis([-1,3].*f) ;
title([title_text,'Vertical vorticity field at ',vortdepth,'m depth.'],'FontSize',14) ;
xlabel('Along channel distance (km).') ;
ylabel('Across channel distance (km).') ;
%colorbar('vert') ;

subplot(2,1,2) ;
contour(p_x_grid./1000,p_y_grid./1000,theta_slice,6) ;
%pcolor(p_x_grid./1000,p_y_grid./1000,theta_slice) ;
%shading flat
%caxis([11.6 12]) ;
title([title_text,'Temperature field at ',thetadepth,'m depth.'],'FontSize',14) ;
xlabel('Along channel distance (km).') ;
ylabel('Across channel distance (km).') ;
%colorbar('vert') ;

orient tall
return
