% Script to plot a figure of various diagnostyic quantities from the CM5 channel 
% integrations, including the estimated eddy length from auto-correlation zero-
% crossings.
% Author : Tom Haine, Feb '95.

function zero_cross_fig(times, theta_zero_cross, v_zero_cross, length, i, param_file_name, ...
                        max_temp, min_temp, mean_temp, one_D_temp) ;

% Do a plot of zero crossing vs time, mean temp vs time, max temp vs time, std dev
% temp vs time.

figure
subplot(2,1,1)
plot(times,theta_zero_cross.*0.25,'+')
hold on
plot(times,v_zero_cross.*0.25,'*')
plot(times,length./1000,'o')
axis([0 times(i) 0 10]) ;
title([param_file_name,'Eddy size from autocorrelation zero-crossings and gradient definition.']) ;
text(1,8,'+ = temperature; * = v; o = gradient') ;
xlabel('Model daynumber') ;
ylabel('Eddy scale (km)') ;

subplot(2,1,2)
plot(times,max_temp,'+') ;
hold on
plot(times,mean_temp,'o') ;
plot(times,min_temp,'+') ;
plot(times,one_D_temp,'*') ;
title([param_file_name, ...
'Along channel center, surface temperatures : + = max/min, o = mean, * = 1D']) ;
axis([0 times(i) 11.5 12]) ;
xlabel('Model daynumber') ;
ylabel('Temperature (oC)') ;

orient tall
hold off

return
