function  H=heat(H0,y,y0,L)
% Compute heat flux
% NB H0 is the AVERAGE heat flux across y if y0 = max(y)/2 (i.e symmetric
% shape). It is also equal to the value of heat flux at the point of
% maximum gradient.
% The maximum value that H can each is 2*H0, but this will only be attained if y >> y0.
H=H0*(tanh((y-y0)*2/L)+1);
