function [dz,zt,zc,z3]=levels(n,H,z1,z2,z4)
% solve for grid spacing given depth, min thickness and max thickness
% width of transition zone and number of levels
% ====input====
% n : number of gridpoints
% H : depth of bottom of deepest gridpoint
% z1: maximum layer depth
% z2: mimimun layer depth
% z4: width of transition zone
% ===output====
% dz: spacing
% zt: top cell depth
% zc: center cell depth
% z3: center of transition zone


Hmin=n*z2;
Hmax=n*z1;
if (H<=Hmin)
  disp(' make small grid spacing smaller')
  return
end
if (H>=Hmax)
  disp(' make large grid spacing bigger')
  return
end



% initial guess for center depth of trasition zone
z3=(H-n*z1)/(z2-z1)*z2 ;

nn=0;
zb=0;
% check for iteration goals
while(abs(zb-H)>H/1000 | nn>100)
 nn=nn+1;
 % evaluate spacing
 z=0;
 for i=1:n
  dz(i)=(z1-z2)/2*(tanh(2*(z-z3)/z4)+1)+z2;
  zt(i)=z;
  zc(i)=z+dz(i)/2;
  z=z+dz(i);
 end
 % decide for changes
 zb=zt(n)+dz(n);
 dd=(zb-H);
 z3=z3+dd/z1*z2;
% disp([' zb ',num2str(zb),' z3 ',num2str(z3)]) ;
end

%plot(zc,dz,'o') ;
return
