% Function to calculate the fitting parameter for a heat flux parameterisation of
% baroclinic eddies due to Tom. Also return the fitted heat flux.
% Stone's form where flux = gamma * (zone_width^2) / teady * by * Bu
% 
% Author Tom, 22/11/95. 

function [best_gamma,flux] = param_G(E, times, T_prime, H, tinst, zone_width, const_flag) ;

global rho_bar c alpha g f N2 x_domain secs_in_a_day 

% Put times into seconds.
times = times .* secs_in_a_day ;
tinst = tinst  * secs_in_a_day ;

% Get lateral temperature gradient. 
Ty = T_prime./zone_width ;

% Get u. u = uz.H = (alpha.g/f).Ty.H
u = (alpha*g/f).*Ty.*H ;

% Get Lr
Lr = (sqrt(N2)/f).*H ;

% Get Bu
Bu = (Lr./zone_width).^2 ;

% Get teady
teady = Lr./u ;

% Form transfer coefficient.
K = ((zone_width^2)./teady).*Bu ;

% Set K = constant = K(tinst)
if (const_flag == 1)
   K = csapi(times,K,tinst) ;
end

% Calculate flux as a function of time WITHOUT the gamma scaling.
flux = K.*T_prime./zone_width ;

% Use splines to do integral. 
pp = csapi(times, flux.*H) ;
ipp = fnint(pp) ;
integral = fnval(ipp,times)' ;

% Find vector of gammas for each element of the times vector.
gamma       = -(1/(x_domain*rho_bar*c)) .* (E ./ integral) ;

% Get a best guess at gamma by least squares fitting.
best_gamma  = -(x_domain*c*rho_bar) .* integral \ E ;

flux = integral.*(best_gamma*rho_bar*c*x_domain) ;

return ;
