% Shell script to run diagnostic2 function many times.
% Author : Tom Nov '95.

clear
clear global
close

fprintf(1,' Run diagnostic many times (fit parameterisations).\n') ;

key = input(' Set transfer coefficient constant ?  (y/n) : ','s') ;
if (key == 'y' | key == 'Y')
   flag = 1 ;
else
   flag = 0 ;
end

expts = [1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 17, 18, 19] ;

for i = 1:size(expts,2)

   fprintf(1,'\n Expt : %d ...',expts(i)) ;
   this_expt = ['Expt',num2str(expts(i))] ;
   this_expt_times = [this_expt,'.times'] ;

   best_gamma = [best_gamma;diagnostic3(this_expt,this_expt_times, flag)] ;

end
best_gammaG   = best_gamma(:,1) ; 
best_gammaS   = best_gamma(:,2) ; 
best_gammaNI  = best_gamma(:,3) ; 
best_gammaNII = best_gamma(:,4) ; 

statsS   = [mean(best_gammaS),std(best_gammaS), (100*std(best_gammaS))/mean(best_gammaS)] ;
statsG   = [mean(best_gammaG),std(best_gammaG), (100*std(best_gammaG))/mean(best_gammaG)] ;
statsNI  = [mean(best_gammaNI),std(best_gammaNI), (100*std(best_gammaNI))/mean(best_gammaNI)] ;
statsNII = [mean(best_gammaNII),std(best_gammaNII), (100*std(best_gammaNII))/mean(best_gammaNII)] ;

fprintf(1,'\n\n Results of parameterisations : (best values for empirical constant) \n') ;
fprintf(1,' Expt #,  Green,  Stone,  NewI,  NewII  \n') ;
fprintf(1,' %2d       %6.4f   %5.3f   %5.3f  %5.3f \n',[expts',best_gamma]') ;

fprintf(1,'\n Means, std. deviations, %% std. deviations : \n\n') ;
fprintf(1, ...
' Green   :  [%f +/- %f, (%4.1f%%)], \n Stone   :  [%f +/- %f, (%4.1f%%)], \n New I   :  [%f +/- %f, (%4.1f%%), \n New II  :  [%f +/- %f, (%4.1f%%)].\n\n', ...
        statsG, statsS, statsNI, statsNII) ;

fprintf(1,' Mean Burger number is [%5.4f, %5.4f] comparing [New:Green] and [Stone:NewII].\n\n', ...
        (statsG(1)/statsNII(1)).^2, (statsNII(1)/statsS(1))^2 ) ;

if (flag == 1)
   fprintf(1,' \n The transfer coefficient was constant.\n\n') ;
else
   fprintf(1,' \n The transfer coefficient was variable.\n\n') ;
end


