% Script to calculate the analytical fields for a symmetric instability problem
% given the mixed layer base (constant slope) and thermocline density field. Assumes
% PV = 0, => Ri = 1.
%
% Author : Tom Oct '95.

function symmetric(H_zero,Hy,Nth,theta_ref,zoom_x,zoom_y) ;

% Constants. SI units unless explicitly stated otherwise.
Earth_rad  = 6370e3 ;
Radian     = 57.29578 ;
g          = 9.81 ;
c          = 4e3 ;
rho_bar    = 1000 ;
True       = 1 ;
False      = 0 ;
alpha      = 2e-4 ;
f          = 1e-4 ;
secs_in_a_day = 60*60*24 ;

% Domain of problem.
%z_domain = 1000 ;
%y_domain = 10000 ;
z_domain = abs(zoom_y(1) - zoom_y(2)) ;
y_domain = abs(zoom_x(1) - zoom_x(2))*1000  ;
y_grid = [0: 50:y_domain] ;
z_grid = [0:-10:-z_domain]' ;

[Y,Z] = meshgrid(y_grid,z_grid) ; 

% Parameter values.
%Nth = 8e-4 ;
%Hy  = 0.06 ;
%H_zero = 350 ;
%theta_ref = 10 ;

H = (H_zero + y_grid.*Hy) ;

% Define basic temperature field from thermocline strat.
theta =  ((Z+z_domain).*(Nth*Nth/(alpha*g)) + theta_ref) ;

% For z > H, Ri = 1. Find values of Nmix. 
quadratic = [Hy f -(Hy*Nth*Nth)] ;
Nmix = max(roots(quadratic)) ;
Mmix = i*sqrt(Nmix*f) ;
slope = (Mmix^2/Nmix^2)
Nmix/f

% Get indices of mixed layer in rho array by comparing H and z_grid.
col_nos = [1:size(z_grid)] ;
temp    = interp1(z_grid,col_nos,-H)' ;
indices = ceil(temp) ;
theta_at_H = interp1(z_grid,theta(:,1),-H) ;

% Define velocity field.
temp = Hy*y_domain ;
%surf_u = z_domain*temp/2 - H_zero*temp/2 - temp^2/3 + z_domain*H_zero - H_zero^2/2 ;

surf_u = z_domain*H_zero + (z_domain*temp)/2 - (H_zero^2)/2 - (temp*H_zero)/2 - ...
         (temp^2)/6 ;

surf_u = surf_u*(Nmix/z_domain) ;
u = zeros(size(theta)) ;

% Join on thermocline. Loop over the columns.
fprintf(1,'\n Please wait ...') ;
for i = 1:size(indices,2)
   temp = [1:indices(i)] ;
   temp2 = [max(temp)+1 : size(theta,1)] ;
   theta(temp,i) = (z_grid(temp)+H(i)).* ...
            (Nmix*Nmix/(alpha*g)) + theta_at_H(i)  ;
   u(temp,i) = +z_grid(temp).* Nmix + surf_u ;
   u(temp2,i) = surf_u - ones(size(temp2))'.*Nmix.*H(i) ;
end

% Angular momentum
M = -(u - f.*Y) ;

fprintf(1,'\n') ;

figure
subplot(2,1,1) ;
c1 = contour(10+(Y./1000),Z,theta,10) ;
%clabel(c1,'manual') ;
hold on
c2 = contour(10+(Y./1000),Z,M./1000,10,':') ;
%clabel(c2,'manual') ;
plot(10+(y_grid./1000),-H,'--','LineWidth',2)
xlabel('Cross channel distance (km)') ;
ylabel('Depth (m)') ;
axis([10 20 -1000 0]) ;

subplot(2,2,3) ;
plot(theta(:,i/2),z_grid,'-') ;
xlabel('Theta profile (C)') ;
ylabel('Depth (m)') ;
subplot(2,2,4) ;
plot(u(:,i/2),z_grid,'-') ;
xlabel('Along channel speed (m/s)') ;
ylabel('Depth (m)') ;

orient tall
