% Function to calculate the kinetic energy of a model field. Requires the flow
% specified everywhere, then simply forms the quadratic KE.
% Actually form the kinetic energy per unit volume, in units J/m^3, from 
% E = rho_bar(u^2 + v^2 + w^2).

% Author twnh, Nov '94.

function KE 

global u_x_grid v_x_grid w_x_grid p_x_grid 
global u_y_grid v_y_grid w_y_grid p_y_grid 
global u_z_grid v_z_grid w_z_grid p_z_grid 
global x_domain y_domain z_domain NX NY NZ
global u v w E theta rho_bar

fprintf(1,' Calculating kinetic energy ... \n') ;

% Use the theta variable to remove the land regions from the velocity matrices.
fprintf(1,' Removing land ... \n') ;
mask = (abs(theta) > eps) ;
[x,y] = find(mask == 0) ;
for i = 1:length(x)
  u(x(i),y(i))     = NaN ;
  v(x(i),y(i))     = NaN ;
  w(x(i),y(i))     = NaN ;
end
clear x y mask

% Form the velocity components at the same point in each cell; the cell's centre
% defined by the p_ grids.
fprintf(1,' Regridding to cell centre ... \n') ;
u_at_p = regrid(u,'x',u_x_grid,p_x_grid,x_domain) ;
v_at_p = regrid(v,'y',v_y_grid,p_y_grid,y_domain) ;
w_at_p = regrid(w,'z',w_z_grid,p_z_grid,z_domain) ;

% Form the quadratic expression for the KE.
fprintf(1,' Forming kinetic energy ...\n') ;
E = rho_bar .* (u.^2 + v.^2 + w.^2) ;

return
